<# 
Beheren bestanden

Programma om bestanden in studentmappen te beheren, dus te kopiren, backuppen, verplaatsen of wissen.

Zie voor versienummer onder "Declareren variabelen".

Versienummer wordt volgens Semantic Versioning uitgevoerd (zie https://Semver.org)

Dit programma is beschermt met auteursplicht door middel van de GNU GPL (https://www.gnu.org/licenses)

Lees ook de readme.txt op https://neveshuis.nl/beherenbestanden/readme.txt
#>

# toevoegen .NET framework klassen ---------------------------------------------------------
Add-Type -AssemblyName PresentationFramework
Add-Type -AssemblyName System.Drawing
Add-Type -AssemblyName System.Windows.Forms

# VisualStyles aan zetten ------------------------------------------------------------------
[System.Windows.Forms.Application]::EnableVisualStyles()

<# Declareren variabelen ---------------------------------------------------------------------
   Bij functie standaardinstellingen onder sectie "Functions" staan de variabelen die door gebruikers
   gewijzigd kunnen worden #>

# versie wordt weergegeven in de titel
[string]$global:Versie = "4.0.0"

# buildnummer wordt weergegeven bij info over programma
[string]$buildnummer = "133.220623"

# startmap met digitale bestanden
$digitalebestanden="B:\HR_TM_T2000\examendocumenten\digitale bijlagen"
# $digitalebestanden="C:\Users\0101925\testwerking\digitale bijlagen"

# locatie van home-map van de studenten
$homemapstudenten="Y:\RPC"
# $homemapstudenten="C:\Users\0101925\testwerking\doel"

# backupmap voor bewaren van kandidaatmappen
$backupmap="B:\HR_TM_T2000\backup kandidaten"
# $backupmap="C:\Users\0101925\testwerking\backup kandidaten"

# startmap van het programma
$startmap=Split-Path -Parent $PSCommandPath

# map met png icoontjes
$icoontjesmap = -join ("$startmap","\","png")

# map voor logbestanden
$logmap = -join ("$startmap","\","log")

<# object met alle variabelen die in initialisatiebestand bewaard worden. Dit zijn de instellingen die gewijzigd kunnen worden.
   Zie ook functie standaardinstellingen onder sectie "Functions" #>
$Global:init=@{}

# bestand met variabelen die gewijzigd kunnen worden en of extern bewaard moeten worden
$initbestand = "config.ini"
# volledige pad toevoegen aan variabele
$initbestand = -join ("$startmap","\","$initbestand")

# website met updates van programma
$updatewebsite = "https://neveshuis.nl/beherenbestanden/updates"

# bestand met info over update. staat op de website
$global:updateinfo = "updateinfo.ini"

# script die het programma update. deze is in de root aanwezig.
$updater = "updater.ps1"

# Einde declareren variabelen

# opstart venster declareren en weergeven ----------------------------------------------------------------------
$Form_opstart                            = New-Object system.Windows.Forms.Form
$Form_opstart.ClientSize                 = New-Object System.Drawing.Point(450,180)
$Form_opstart.text                       = "Beheren bestanden versie " + "$global:Versie"
$Form_opstart.TopMost                    = $false
$Form_opstart.StartPosition              = 'CenterScreen'

$opstarttekst                     = New-Object system.Windows.Forms.Label
$opstarttekst.text                = "Programma wordt opgestart."
$opstarttekst.AutoSize            = $false
$opstarttekst.width               = 300
$opstarttekst.height              = 30
$opstarttekst.location            = New-Object System.Drawing.Point(20,15)
$opstarttekst.Font                = 'Microsoft Sans Serif,12'
$opstarttekst.ForeColor = [System.Drawing.Color]::Blue
$Form_opstart.Controls.Add($opstarttekst)

$opstartinfo                     = New-Object system.Windows.Forms.Label
$opstartinfo.text                = ""
$opstartinfo.AutoSize            = $false
$opstartinfo.width               = 400
$opstartinfo.height              = 100
$opstartinfo.location            = New-Object System.Drawing.Point(20,50)
$opstartinfo.Font                = 'Microsoft Sans Serif,12'
$opstartinfo.ForeColor = [System.Drawing.Color]::Blue
$Form_opstart.Controls.Add($opstartinfo)

$Form_opstart.Show()


# Hoofdvenster declareren --------------------------------------------------------------------

$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = New-Object System.Drawing.Point(900,550)
$Form.text                       = "Beheren bestanden versie " + "$global:Versie"
$Form.TopMost                    = $false
$Form.StartPosition              = 'CenterScreen'

$Description                     = New-Object system.Windows.Forms.Label
$Description.text                = "Programma voor het beheren van digitale bestanden. 
Maak een keuze door op een icoontje of tekst te klikken."
$Description.AutoSize            = $false
$Description.width               = 520
$Description.height              = 42
$Description.location            = New-Object System.Drawing.Point(20,15)
$Description.Font                = 'Microsoft Sans Serif,12'
$Description.ForeColor = [System.Drawing.Color]::Blue

$uitleg1                     = New-Object system.Windows.Forms.Label
$uitleg1.text                = "Kopiren van bestanden naar de studentmappen."
$uitleg1.AutoSize            = $false
$uitleg1.width               = 350
$uitleg1.height              = 40
$uitleg1.location            = New-Object System.Drawing.Point(90,80)
$uitleg1.Font                = 'Microsoft Sans Serif,11'
$uitleg1.ForeColor = [System.Drawing.Color]::Green
$uitleg1.add_MouseEnter( {$uitleg1.ForeColor = [System.Drawing.Color]::blue} )
$uitleg1.add_MouseLeave( {$uitleg1.ForeColor = [System.Drawing.Color]::green } )
$uitleg1.Add_Click({ vensterkopieren })

$uitleg2                     = New-Object system.Windows.Forms.Label
$uitleg2.text                = "Backup maken van de studentmappen."
$uitleg2.AutoSize            = $false
$uitleg2.width               = 350
$uitleg2.height              = 40
$uitleg2.location            = New-Object System.Drawing.Point(90,140)
$uitleg2.Font                = 'Microsoft Sans Serif,11'
$uitleg2.add_MouseEnter( {$uitleg2.ForeColor = [System.Drawing.Color]::blue} )
$uitleg2.add_MouseLeave( {$uitleg2.ForeColor = [System.Drawing.Color]::green } )
$uitleg2.ForeColor = [System.Drawing.Color]::Green
$uitleg2.Add_Click({ vensterbackup })

$uitleg3                     = New-Object system.Windows.Forms.Label
$uitleg3.text                = "Wissen van bestanden uit de studentmappen."
$uitleg3.AutoSize            = $false
$uitleg3.width               = 350
$uitleg3.height              = 40
$uitleg3.location            = New-Object System.Drawing.Point(90,200)
$uitleg3.Font                = 'Microsoft Sans Serif,11'
$uitleg3.add_MouseEnter( {$uitleg3.ForeColor = [System.Drawing.Color]::blue} )
$uitleg3.add_MouseLeave( {$uitleg3.ForeColor = [System.Drawing.Color]::green } )
$uitleg3.ForeColor = [System.Drawing.Color]::Green
$uitleg3.Add_Click({ vensterwissen })

$uitleg4                     = New-Object system.Windows.Forms.Label
$uitleg4.text                = "Verplaatsen van bestanden tussen studentmappen."
$uitleg4.AutoSize            = $false
$uitleg4.width               = 350
$uitleg4.height              = 40
$uitleg4.location            = New-Object System.Drawing.Point(90,260)
$uitleg4.Font                = 'Microsoft Sans Serif,11'
$uitleg4.ForeColor = [System.Drawing.Color]::Green
$uitleg4.add_MouseEnter( {$uitleg4.ForeColor = [System.Drawing.Color]::blue} )
$uitleg4.add_MouseLeave( {$uitleg4.ForeColor = [System.Drawing.Color]::green } )
$uitleg4.Add_Click({ vensterverplaatsen })


$uitleg6                     = New-Object system.Windows.Forms.Label
$uitleg6.text                = "Programma sluiten."
$uitleg6.AutoSize            = $false
$uitleg6.width               = 350
$uitleg6.height              = 40
$uitleg6.location            = New-Object System.Drawing.Point(90,380)
$uitleg6.Font                = 'Microsoft Sans Serif,11'
$uitleg6.ForeColor = [System.Drawing.Color]::Red
$uitleg6.add_MouseEnter( {$uitleg6.ForeColor = [System.Drawing.Color]::blue} )
$uitleg6.add_MouseLeave( {$uitleg6.ForeColor = [System.Drawing.Color]::Red} )
$uitleg6.Add_Click({ programmaafsluiten })

$uitleg7                     = New-Object system.Windows.Forms.Label
$uitleg7.text                = "Logbestanden bekijken."
$uitleg7.AutoSize            = $false
$uitleg7.width               = 350
$uitleg7.height              = 40
$uitleg7.location            = New-Object System.Drawing.Point(550,80)
$uitleg7.Font                = 'Microsoft Sans Serif,11'
$uitleg7.ForeColor = [System.Drawing.Color]::Green
$uitleg7.add_MouseEnter( {$uitleg7.ForeColor = [System.Drawing.Color]::blue} )
$uitleg7.add_MouseLeave( {$uitleg7.ForeColor = [System.Drawing.Color]::green} )
$uitleg7.Add_Click({ vensterlogbestand })

$uitleg8                     = New-Object system.Windows.Forms.Label
$uitleg8.text                = "Controleren op een update van het programma."
$uitleg8.AutoSize            = $false
$uitleg8.width               = 350
$uitleg8.height              = 40
$uitleg8.location            = New-Object System.Drawing.Point(550,140)
$uitleg8.Font                = 'Microsoft Sans Serif,11'
$uitleg8.ForeColor = [System.Drawing.Color]::Green
$uitleg8.add_MouseEnter( {$uitleg8.ForeColor = [System.Drawing.Color]::blue} )
$uitleg8.add_MouseLeave( {$uitleg8.ForeColor = [System.Drawing.Color]::green} )
$uitleg8.Add_Click({ updatevoorbereiden ("keuzemenu") })

$Button1                         = New-Object system.Windows.Forms.Button
$Button1.width                   = 60
$Button1.height                  = 60
$Button1.location                = New-Object System.Drawing.Point(20,60)
$Button1.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button1.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-copy.png")
$Button1.Add_Click({ vensterkopieren })

$Button2                         = New-Object system.Windows.Forms.Button
$Button2.width                   = 60
$Button2.height                  = 60
$Button2.location                = New-Object System.Drawing.Point(20,120)
$Button2.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button2.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-backup.png")
$Button2.Add_Click({ vensterbackup })

$Button3                         = New-Object system.Windows.Forms.Button
$Button3.width                   = 60
$Button3.height                  = 60
$Button3.location                = New-Object System.Drawing.Point(20,180)
$Button3.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button3.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-delete.png")
$Button3.Add_Click({ vensterwissen })

$Button4                         = New-Object system.Windows.Forms.Button
$Button4.width                   = 60
$Button4.height                  = 60
$Button4.location                = New-Object System.Drawing.Point(20,240)
$Button4.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button4.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-verplaatsen.png")
$Button4.Add_Click({ vensterverplaatsen })


$Button6                         = New-Object system.Windows.Forms.Button
$Button6.width                   = 60
$Button6.height                  = 60
$Button6.location                = New-Object System.Drawing.Point(20,360)
$Button6.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button6.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-stoppen.png")
$Button6.Add_Click({ programmaafsluiten })

$Button7                         = New-Object system.Windows.Forms.Button
$Button7.width                   = 60
$Button7.height                  = 60
$Button7.location                = New-Object System.Drawing.Point(480,60)
$Button7.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button7.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-log.png")
$Button7.Add_Click({ vensterlogbestand })

$Button8                         = New-Object system.Windows.Forms.Button
$Button8.width                   = 60
$Button8.height                  = 60
$Button8.location                = New-Object System.Drawing.Point(480,120)
$Button8.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button8.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-update.png")
$Button8.Add_Click({ updatevoorbereiden ("keuzemenu") })


$Form.controls.AddRange(@($Description,$Button1,$Button2, $Button3, $Button4, $Button6, $Button7, $Button8, $uitleg1, $uitleg2, $uitleg3, $uitleg4, 
$uitleg6, $uitleg7, $uitleg8 ))

# Einde hoofdvenster declareren


# functions ---------------------------------------------------------------------------------
# hieronder de kleine functies die door andere functies gebruikt worden ---------------------

function bepaallognaam ($invoer)

{
<# de lognaam wordt bepaald adhv de invoer. dit is een datum in de format yyyy-mm-dd.
   functie "bepaaldatumuitlognaam" doet het omgekeerde, dus een verandering hier moet ook in deze functie worden aangepast.
#>
$lognaam = -join ("$logmap","\log_","$invoer",".txt")

return $lognaam
}

function bepaaldatumuitlognaam ($invoer)
{
<# Uit de invoer wordt de datum bepaald. De format hiervoor staat in functie "bepaallognaam".
  Een wijziging in deze functie moet hier ook worden toegepast.
#>
$datumintekst = $invoer.substring(4, 10)
return $datumintekst
}

function bepaalversiemap ($invoer)
{
# bepaalt de map waar de versie in staat mbv de gegeven versie (invoer)

$major = $invoer.split('.')[0]
$minor = $invoer.split('.')[1]
$revision = $invoer.split('.')[2]

$versiemap = -join ("$updatewebsite","/","$major",".","$minor" )
return $versiemap
}

function standaardinstellingen 
{
# hier worden de standaard instellingen gedeclareerd die gebruikers kunnen wijzigen

$Std_inst=@{}
$Std_inst["algemeen"]=@{}
$Std_inst["algemeen"]["locatiekeuze"]="PAL"
$Std_inst["algemeen"]["autoupdate"]="ja"
$Std_inst["algemeen"]["wissennabackup"]="ja"
$Std_inst["algemeen"]["updatenotificatie"]="ja"
$Std_inst["locaties"]=@{}
$Std_inst["locaties"]["PAL"]="Prins Alexanderlaan"
$Std_inst["locaties"]["SHW"]="Schiedamseweg"
$Std_inst["locaties"]["JLS"]="Jan Ligthartstraat"
$Std_inst["PAL"]=@{}
$Std_inst["PAL"]["eerstenr"]=1
$Std_inst["PAL"]["laatstenr"]=50
$Std_inst["SHW"]=@{}
$Std_inst["SHW"]["eerstenr"]=131
$Std_inst["SHW"]["laatstenr"]=180
$Std_inst["JLS"]=@{}
$Std_inst["JLS"]["eerstenr"]=201
$Std_inst["JLS"]["laatstenr"]=240

return $Std_inst
}

function Get-IniContent ($filePath)
{
    $ini = @{}
    switch -regex -file $FilePath
    {
        ^\[(.+)\] # Section
        {
            $section = $matches[1]
            $ini[$section] = @{}
            $CommentCount = 0
        }
        ^(;.*)$ # Comment
        {
            $value = $matches[1]
            $CommentCount = $CommentCount + 1
            $name = Comment + $CommentCount
            $ini[$section][$name] = $value
        }
        (.+?)\s*=(.*) # Key
        {
            $name,$value = $matches[1..2]
            $ini[$section][$name] = $value
        }
    }
    return $ini
}

function Out-IniFile ($InputObject,$FilePath)
{
    # eerst oude verwijderen
    if ((test-path -path $FilePath -pathtype leaf) -eq $true) {Remove-Item $Filepath -Force }

    $outFile = New-Item -ItemType file -Path $Filepath
    foreach ($i in $InputObject.keys)
    {
        if (!($($InputObject[$i].GetType().Name) -eq Hashtable))
        {
            #No Sections
            Add-Content -Path $outFile -Value $i=$($InputObject[$i])
        } else {
            #Sections
            Add-Content -Path $outFile -Value [$i]
            Foreach ($j in ($InputObject[$i].keys | Sort-Object))
            #Foreach ($j in ($InputObject[$i].keys))
            {
                if ($j -match ^Comment[\d]+) {
                    Add-Content -Path $outFile -Value $($InputObject[$i][$j])
                } else {
                    Add-Content -Path $outFile -Value $j=$($InputObject[$i][$j])
                }

            }
            Add-Content -Path $outFile -Value 
        }
    }
}

function declareren_rpcnrs {

# Venster voor weergeven rpcnummer declareren. Wordt bij meerdere functies gebruikt.

$listbox_temp = New-Object System.Windows.Forms.Listbox
$listbox_temp.Location = New-Object System.Drawing.Point(10,40)
$listbox_temp.Size = New-Object System.Drawing.Size(150,20)
$listbox_temp.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listbox_temp.SelectionMode = 'MultiExtended'
$listbox_temp.Height = 500

return $listbox_temp
}

function lijstrpcnrsaanmaken ($keuzelocatie, $listbox_temp) {

# lijst leeg maken
$listbox_temp.Items.Clear()

# waarden uit array halen die nodig zijn om lijst te maken met rpc-nummers
[int]$keuzeeerstenr=$init["$keuzelocatie"]["eerstenr"]
[int]$keuzelaatstenr=$init["$keuzelocatie"]["laatstenr"]

#listbox items aanmaken
For ($i=$keuzeeerstenr; $i -le $keuzelaatstenr; $i++) {

    if ($i -lt 10) {$rpcnr="RPC-00"+"$i"}
    elseif ($i -lt 100) {$rpcnr="RPC-0"+"$i"}
    else {$rpcnr="RPC-"+"$i"}
    [void] $listbox_temp.Items.Add($rpcnr)
}

return $listbox_temp
}

# hieronder de hoofdfuncties ----------------------------------------------------------------

function uitvoerentaken ([string]$taak) {

# controleren of mappen bestaan - afhankelijk van de taak
# map homemapstudenten wordt in ieder geval gecontroleerd

if (!(test-path -path $homemapstudenten -pathtype container)) {
    $null = [System.Windows.Forms.MessageBox]::Show("De homemappen van de studenten zijn niet gevonden!

    Controleer of de volgende map aanwezig is :
    $homemapstudenten
    De taak kan nu niet uitgevoerd worden." , "Map bestaat niet",  "OK" , "Error")
    return;
} # einde test voor map homemapstudenten

if ($taak -eq "kopiren") {
if (!(test-path -path $digitalebestanden -pathtype container)) {
    $null = [System.Windows.Forms.MessageBox]::Show("De map met de te kopiren bestanden is niet gevonden!

    Controleer of de volgende map aanwezig is :
    $digitalebestanden
    De taak kan nu niet uitgevoerd worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}
} # einde test voor map digitalebestanden

if ($taak -eq "backup") {
if (!(test-path -path $backupmap -pathtype container)) {
    $null = [System.Windows.Forms.MessageBox]::Show("De backupmap is niet gevonden!

    Controleer of de volgende map aanwezig is :
    $backupmap
    De taak kan nu niet uitgevoerd worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}
} # einde test voor map backupmap


# startknop wordt onzichtbaar
$StartButton.Hide()
$Btnescape.Hide()

# het proces zichtbaar maken in een balk
$ProgressBar = New-Object System.Windows.Forms.ProgressBar
$ProgressBar.Location = New-Object System.Drawing.Point(10, 450)
$ProgressBar.Size = New-Object System.Drawing.Size(560, 40)
$ProgressBar.Style = "continuous"
# aantal geselecteerde rpcnrs bepaalt de maximumwaarde van de progressbar
$ProgressBar.maximum = $listbox.selecteditems.count
$ProgressBar.step = 1

# ProgressBar toevoegen aan form3
$form3.Controls.Add($ProgressBar);

$Label.ForeColor = 'red'
$Label.Text = "Taken worden uitgevoerd ..."
$ProgressBar.visible

# datum bepalen
$datumvandaag = get-date -Format "yyyy-MM-dd"

# logbestandsnaam definiren en volledige pad naar bestand invoeren
# $logbestand = -join ("$logmap","\log_","$datumvandaag",".txt")
$logbestand = bepaallognaam "$datumvandaag"

# starttijd van loggen naar variabele
$logtijd = get-date -Format "HH:mm:ss"

# map aanmaken voor logbestanden als deze niet bestaat
if (!(Test-Path "$logmap")) { mkdir "$logmap" } 

# in logbestand schrijven - info over de taa
" -------------------------------------------------------------------------" | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append
"De taak '$taak' is uitgevoerd." | out-file $logbestand -Append
$objtekst1.Text | out-file $logbestand -Append
if ($taak -eq "kopiren") {
    $objtekst2.Text | out-file $logbestand -Append
}

# nodig voor afhandelen foutmeldingen
$foutmelding = $false
$tekstfoutmelding = " *** Foutmeldingen *** "

# takenuitvoeren die gegeven zijn.
switch ($taak) {

    "backup"   { 

    #kopiren bestanden naar studentmappen
    foreach ($rpcitem in $listbox.selecteditems) {
        # progressie laten zien op balk
        $ProgressBar.PerformStep()

        # foutmeldingen voor huidige rpcnr uitzetten
        $foutmelding_rpc = $false
        
        $error.clear()
        try {
            #backup maken
            Copy-Item -path "$homemapstudenten\$rpcitem" -destination "$backupmap\$datumvandaag\$rpcitem" -recurse -Force -container -ErrorAction Stop

            if ($wissennabackup.checked -eq $true) { 
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "$homemapstudenten\$rpcitem\mijn documenten\*" -Recurse -Force -ErrorAction Stop
                # dan de root van rpc-map exclusief map mijn documenten
                Remove-Item "$homemapstudenten\$rpcitem\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                }
            } # einde try

        catch {
                # Tekst weergeven bij eerste foutmelding
                if (!($foutmelding)) {
                    $tekstfoutmelding | out-file $logbestand -Append
                    $foutmelding = $true
                    }
                # Tekst weergeven bij eerste foutmelding van een rpc-nummer
                if (!($foutmelding_rpc)) {
                    " *** voor $rpcitem  ***" | out-file $logbestand -Append
                    $foutmelding_rpc = $true
                    }

                # foutmelding van PowerShell naar logbestand
                $_.exception.message | out-file $logbestand -Append

                  } # einde catch
    }
    # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
    $listbox.selecteditems.clear()
               } # einde taak backup

    "kopiren" { 

    # array aanmaken en vullen met geselecteerde items. 
    # Deze items worden vervolgens gekopierd.
    $geselecteerdeitems = [System.Collections.ArrayList]@()

    <# Als er geen items zijn geselecteerd in de examenmap dan moet de gehele map worden gekopierd.
   hiervoor wordt dan de pad naar de examenmap toegevoegd aan de array $geselecteerdeitems.
   anders worden de geselecteerde items toegevoegd aan de array.
    #>
    if ($listbox2.selecteditems.count -eq 0) {
        $geselecteerdeitems.Add("$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\*")
        } else {
        foreach ($item in $listbox2.selecteditems) {
            $geselecteerdeitems.Add("$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\$item")
        }
    }

    #kopiren bestanden naar studentmappen

    foreach ($rpcitem in $listbox.selecteditems) {
        # progressie laten zien op balk
        $ProgressBar.PerformStep()

        # foutmeldingen voor huidige rpcnr uitzetten
        $foutmelding_rpc = $false

        foreach ($item in $geselecteerdeitems) {
            $error.clear()
            try {
                Copy-Item -path "$item" -destination "$homemapstudenten\$rpcitem\Mijn Documenten"  -recurse -ErrorAction Stop
                }

            catch {
                # Tekst weergeven bij eerste foutmelding
                if (!($foutmelding)) {
                    $tekstfoutmelding | out-file $logbestand -Append
                    $foutmelding = $true
                    }
                # Tekst weergeven bij eerste foutmelding van een rpc-nummer
                if (!($foutmelding_rpc)) {
                    " *** voor $rpcitem  ***" | out-file $logbestand -Append
                    $foutmelding_rpc = $true
                    }

                # foutmelding van PowerShell naar logbestand
                $_.exception.message | out-file $logbestand -Append

                  } # einde catch
        } # einde foreach $item
    
    } # einde foreach $rpcitem

    # array legen. mss is dit niet nodig!
    $geselecteerdeitems.Clear()
    # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
    $listbox.selecteditems.clear()

               } # einde taak kopiren
    "wissen"   { 
        #wissen van bestanden in studentmappen
        foreach ($rpcitem in $listbox.selecteditems) {
            # progressie laten zien op balk
            $ProgressBar.PerformStep()

            # foutmeldingen voor huidige rpcnr uitzetten
            $foutmelding_rpc = $false
        
            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "$homemapstudenten\$rpcitem\mijn documenten\*" -Recurse -Force -ErrorAction Stop
                # dan de root van rpc-map exclusief map mijn documenten
                Remove-Item "$homemapstudenten\$rpcitem\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                }
            catch {
                # Tekst weergeven bij eerste foutmelding
                if (!($foutmelding)) {
                    $tekstfoutmelding | out-file $logbestand -Append
                    $foutmelding = $true
                    }
                # Tekst weergeven bij eerste foutmelding van een rpc-nummer
                if (!($foutmelding_rpc)) {
                    " *** voor $rpcitem  ***" | out-file $logbestand -Append
                    $foutmelding_rpc = $true
                    }

                # foutmelding van PowerShell naar logbestand
                $_.exception.message | out-file $logbestand -Append

                  } # einde catch
            
            } # einde foreach statement

        # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
        $listbox.selecteditems.clear()
               } # einde taak wissen
    "verplaatsen" {
        # er is maar een actie te doen dus..
        $ProgressBar.maximum = 1

        # definiren bron en doelmap
        $bronmap = -join ($homemapstudenten,"\",$bronselectie.selecteditem,"\Mijn Documenten\*")
        $doelmap = -join ($homemapstudenten,"\",$doelselectie.selecteditem,"\Mijn Documenten")

        $error.clear()
        try {
            # nu kopiren
            Copy-Item -path "$bronmap" -destination "$doelmap" -recurse -ErrorAction Stop

            # verwijderen van bestanden. alleen de inhoud van mijn documenten
            if ($kopiemaken.checked -eq $false) {
                Remove-Item "$bronmap" -Recurse -Force -ErrorAction Stop
                }
            }
        catch {
              # Tekst weergeven bij foutmelding
              $tekstfoutmelding | out-file $logbestand -Append
              $foutmelding = $true
              # foutmelding van PowerShell naar logbestand
              $_.exception.message | out-file $logbestand -Append
              
              } # einde catch

        # progressie laten zien op balk
        $ProgressBar.PerformStep()

        # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
        $doelselectie.selecteditem = $null
        $bronselectie.selecteditem = $null
                  } # einde taak verplaatsen

} # einde switch commando

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
$logtijd = get-date -Format "HH:mm:ss"

if ($foutmelding) { "" | out-file $logbestand -Append }
"Eindtijd  : $logtijd" | out-file $logbestand -Append

# aangeven dat taken zijn uitgevoerd 
if ($foutmelding) { $Label.Text = "De taken zijn niet correct uitgevoerd. Bekijk de foutmeldingen in het logbestand."
    } else { $Label.Text = "Taken zijn uitgevoerd." }

# knoppen zichtbaar maken
$EndButton.show()
$LogButton.show()

# alleen bij taak kopieren onderstaande knop zichtbaar maken
if ($taak -eq "kopiren") {
    $Btnescape.size = New-Object System.Drawing.Size(200,40)
    # escape knop wordt nu opnieuw knop
    $Btnescape.text= "Opnieuw bestanden klaarzettenn"
    $Btnescape.BackColor = 'green'
    $Btnescape.show()
} else {
$LogButton.Location = New-Object System.Drawing.Size(160, 400)
}

}

function overzichttaken ([string]$taak) {

$Form3                            = New-Object system.Windows.Forms.Form
$Form3.ClientSize                 = New-Object System.Drawing.Point(600,500)
$Form3.text                       = "Overzicht uit te voeren taken"
$Form3.TopMost                    = $false
$Form3.StartPosition              = 'CenterScreen'

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.AutoSize            = $false
$Description2.width               = 500
$Description2.height              = 20
$Description2.location            = New-Object System.Drawing.Point(20,10)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor           = 'blue'

# onderstaande tekst wordt alleen zichtbaar als backuptaak is gekozen en wissen na backup is geselecteerd.
$Description3                     = New-Object system.Windows.Forms.Label
$Description3.AutoSize            = $false
$Description3.width               = 500
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(20,28)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.Text                = "De bestanden worden na de backup gewist."
$Description3.ForeColor           = 'blue'
$Description3.hide()

$StartButton = New-Object System.Windows.Forms.Button
$StartButton.Location = New-Object System.Drawing.Size(10, 400)
$StartButton.Size = New-Object System.Drawing.Size(120, 50)
$StartButton.Text = "Start"
$StartButton.height = 40
$StartButton.BackColor = 'green'
$StartButton.ForeColor = 'white'
$StartButton.Add_click( { uitvoerentaken $taak });

$EndButton = New-Object System.Windows.Forms.Button
$EndButton.Location = New-Object System.Drawing.Size(10, 400)
$EndButton.Size = New-Object System.Drawing.Size(120, 50)
$EndButton.Text = "Sluiten"
$EndButton.height = 40
$EndButton.BackColor = 'blue'
$EndButton.ForeColor = 'white'
$EndButton.DialogResult = [System.Windows.Forms.DialogResult]::OK
$EndButton.hide()

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Terug"
$Btnescape.location = New-Object System.Drawing.Size(160, 400)
$Btnescape.size = New-Object System.Drawing.Size(120, 50)
$Btnescape.height = 40
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

$LogButton = New-Object System.Windows.Forms.Button
$LogButton.Location = New-Object System.Drawing.Size(400, 400)
$LogButton.Size = New-Object System.Drawing.Size(170, 50)
$LogButton.Text = "Logbestand bekijken"
$LogButton.height = 40
$LogButton.BackColor = 'blue'
$LogButton.ForeColor = 'white'
$LogButton.hide()
$LogButton.add_click({ 
    $Form2.close()
    $Form3.close()
    vensterlogbestand })

$Label = New-Object System.Windows.Forms.Label
$Label.Font = 'Microsoft Sans Serif,12'
$Label.ForeColor = 'blue'
$Label.Text = "Klaar om de taken uit te voeren ?"
$Label.Location = New-Object System.Drawing.Point(10, 360)
$Label.Width = 480
$Label.Height = 40

switch ($taak) {
    "backup"      { 
                  $Description2.text = "U gaat een backup uitvoeren op de volgende rpc-nummers." 
                  if ($wissennabackup.checked -eq $true) { $Description3.show() }
                  }
    "kopiren"    { $Description2.text = "U gaat bestanden of mappen klaarzetten op de volgende rpc-nummers." }
    "wissen"      { $Description2.text = "U gaat bestanden wissen van de volgende rpc-nummers." }
    "verplaatsen" { 
                  if ($kopiemaken.checked -eq $true) { 
                    $Description2.text = "U gaat bestanden kopiren van een rpc-nummer naar een andere." 
                    } else {
                    $Description2.text = "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." 
                    }
                  }
}

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,60) 
$objtekst1.Size = New-Object System.Drawing.Size(200,290)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = "Geselecteerde rpc-nummers:" + "`r`n" + "`r`n"
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"

$objtekst2 = New-Object System.Windows.Forms.textbox
$objtekst2.Location = New-Object System.Drawing.Size(230,60) 
$objtekst2.Size = New-Object System.Drawing.Size(350,290)
$objtekst2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst2.Text = ""
$objtekst2.ReadOnly = $true
$objtekst2.Multiline = $true
$objtekst2.ScrollBars = "Both"
$objtekst2.Visible = $false

# geselecteerde rpc-nummers links weergeven
# als taak is verplaatsen heb je een andere inhoud dan bij overige taken
if ($taak -eq "verplaatsen") {
    $objtekst1.Text = $objtekst1.Text + " Bron is " + $bronselectie.selecteditem + "`r`n" + "`r`n"
    $objtekst1.Text = $objtekst1.Text + " Doel is " + $doelselectie.selecteditem + "`r`n" + "`r`n"
    } else {
    foreach ($item in $listbox.selecteditems) {
        $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
        }
    }

# geselecteerde mappen bij taak kopiren rechts weergeven. alleen als taak kopieren is geslecteerd
if ($taak -eq "kopiren") {
    $objtekst2.Text = "Geselecteerde bestanden of mappen:" + "`r`n" + "`r`n"
    $objtekst2.Visible = $true

    if ($listbox2.selecteditems.count -eq 0) {
        $objtekst2.Text = $objtekst2.Text + " - " + "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen" + "`r`n"

        } else {
        foreach ($item in $listbox2.selecteditems) {
            $objtekst2.Text = $objtekst2.Text + " - " + "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\$item" + "`r`n"
            }
        }
    }

$Form3.Controls.AddRange(@($Description2, $Description3, $StartButton, $EndButton, $Btnescape, $LogButton, $Label, $objtekst1, $objtekst2 ))

$result = $form3.ShowDialog()

$Form3.Close()

if ($result -eq [system.windows.forms.dialogResult]::OK) { 
    $Form2.Close()
    $form.show()
    }

}

function startknopklikbaar {

# bepalen of knoppen en items van vensterkopieren zichtbaar moeten zijn

# start knop
if (($global:listbox.selecteditems.count -gt 0) -and ($lijstexamens.selecteditem -ne $null)) {
    $Btnstart.Enabled= $true
} else {
    $Btnstart.Enabled= $false
}

}

function vensterkopieren { 

# variabelen

[string]$global:keuzecrebonr=""
[string]$global:keuzekerntaak=""
[string]$global:keuzeexamen=""
$keuzelocatie=$init["algemeen"]["locatiekeuze"]

if (!(test-path -path "$digitalebestanden")) {
    $null = [System.Windows.Forms.MessageBox]::Show("De map met de te kopiren bestanden is niet gevonden!

Controleer of de volgende map aanwezig is :
$digitalebestanden
De taak kan nu niet opgestart worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}

if (!(test-path -path "$homemapstudenten")) {
    $null = [System.Windows.Forms.MessageBox]::Show("De home-map van de studenten is niet gevonden!

Controleer of de volgende map aanwezig is :
$homemapstudenten
De taak kan nu niet opgestart worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# De hoofdmenu onzichtbaar maken
$form.Hide()

$Form2                            = New-Object system.Windows.Forms.Form
$Form2.ClientSize                 = New-Object System.Drawing.Point(900,600)
$Form2.text                       = "Kopiren van bestanden naar de studentmappen"
$Form2.TopMost                    = $false
$Form2.StartPosition              = 'CenterScreen'

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Selecteer in het midden de locatie, crebonummer, kerntaak en examen en selecteer links de rpc-nummers.
Eventueel kunt u alleen enkele mappen of bestanden van een examen in het middelste vakje selecteren. 
Klik op bevestigen om door te gaan."

$Description2.AutoSize            = $false
$Description2.width               = 850
$Description2.height              = 52
$Description2.location            = New-Object System.Drawing.Point(20,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Selecteer de locatie."
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 42
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.location            = New-Object System.Drawing.Point(550,80)
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Selecteer de crebonummer."
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(550,120)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Selecteer de kerntaak."
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(550,160)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description8                     = New-Object system.Windows.Forms.Label
$Description8.text                = "Selecteer het examen."
$Description8.AutoSize            = $false
$Description8.width               = 400
$Description8.height              = 42
$Description8.Font                = 'Microsoft Sans Serif,11'
$Description8.location            = New-Object System.Drawing.Point(550,200)
$Description8.ForeColor = [System.Drawing.Color]::Blue

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Inhoud van geselecteerde examenmap :"
$Description6.AutoSize            = $false
$Description6.width               = 330
$Description6.height              = 42
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.location            = New-Object System.Drawing.Point(200,250)

$Description7                     = New-Object system.Windows.Forms.Label
$Description7.text                = "Inhoud van geselecteerde map in examenmap :"
$Description7.AutoSize            = $false
$Description7.width               = 400
$Description7.height              = 42
$Description7.Font                = 'Microsoft Sans Serif,11'
$Description7.location            = New-Object System.Drawing.Point(550,250)
$Description7.Hide()

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,550" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "kopiren" }) 

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,550" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

# listbox is al in het begin gedeclareerd. onderstaande waarden gelden voor deze functie.
$listBox.Location = New-Object System.Drawing.Point(10,80)
$listBox.Size = New-Object System.Drawing.Size(160,460)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'

# bij aanklikken van een rpcnr, kijken of startknop weergegeven kan worden
$listbox.add_SelectedIndexChanged(
     { startknopklikbaar;
     } )

$global:listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(200,279)
$listBox2.Size = New-Object System.Drawing.Size(330,260)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.SelectionMode = 'MultiExtended'
$listBox2.items.clear()

# bij aanklikken van een map, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged(
     { 
     # selectie krijgt waarde van volledige pad naar gekozen map
     $selectie = "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\" + $ListBox2.SelectedItem

     # alleen als 1 item is geselecteerd EN geselecteerde een map is
     if (($listbox2.selecteditems.count -eq 1) -and ((test-path -path $selectie -pathtype container) -eq $true) ) {
          
          # zichtbaar maken
          $objtekst1.Visible = $true
          $Description7.show()
          # tekstbox inhoud geven
          $objtekst1.Text = ""   

          # weergeven inhoud in tekstbox
          # eerst de volledige inhoud van de map krijgen
          $volledigetext= Get-ChildItem -Path "$selectie"
          # dan netjes in rijen plaatsen.
          foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
               }
          startknopklikbaar;

          } else {
          # venster met inhoud map onzichtbaar maken
          $objtekst1.Visible = $false
          $Description7.Hide()
          }
    }
    )

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(550,279) 
$objtekst1.Size = New-Object System.Drawing.Size(330,245)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.Hide()

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 330
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(200,80) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$init["locaties"].keys | ForEach-Object {
    $waarde=$init["locaties"]["$_"]
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     startknopklikbaar;
     } ) 

$lijstcrebonrs                     = New-Object system.Windows.Forms.ComboBox
$lijstcrebonrs.text                = "Kies een crebonummer"
$lijstcrebonrs.width               = 330
$lijstcrebonrs.autosize            = $true
$lijstcrebonrs.Location = New-Object System.Drawing.Size(200,120) 
$lijstcrebonrs.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstcrebonrs.DropDownStyle="DropDownList"

# crebonummers in de lijst zetten. 
Get-ChildItem -Path $digitalebestanden -Directory -Name | ForEach-Object {[void] $lijstcrebonrs.Items.Add($_)}

# uitvoeren als selectie van crebonummer wijzigt
$lijstcrebonrs.add_SelectedIndexChanged(
     { 
     $lijstkerntaken.items.clear()
     $lijstexamens.items.clear()
     $listBox2.items.clear()
     $objtekst1.Visible = $false
     $Description7.Hide()
     $global:keuzecrebonr = $lijstcrebonrs.selecteditem

     Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr" -Directory -Name | ForEach-Object {[void] $lijstkerntaken.Items.Add($_)}

     startknopklikbaar;
     } )

$lijstkerntaken                     = New-Object system.Windows.Forms.ComboBox
$lijstkerntaken.text                = "Kies een kerntaak"
$lijstkerntaken.width               = 330
$lijstkerntaken.autosize            = $true
$lijstkerntaken.Location = New-Object System.Drawing.Size(200,160) 
$lijstkerntaken.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstkerntaken.DropDownStyle="DropDownList"

# uitvoeren als selectie van kerntaken wijzigt
$lijstkerntaken.add_SelectedIndexChanged(
    {
    $lijstexamens.items.clear()
    $listBox2.items.clear()
    $objtekst1.Visible = $false
    $Description7.Hide()

    $global:keuzekerntaak = $lijstkerntaken.selecteditem

    Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr\$keuzekerntaak" -Directory -Name | ForEach-Object {[void] $lijstexamens.Items.Add($_)}

    startknopklikbaar;
    } )

$lijstexamens                     = New-Object system.Windows.Forms.ComboBox
$lijstexamens.text                = "Kies een examen"
$lijstexamens.width               = 330
$lijstexamens.autosize            = $true
$lijstexamens.Location = New-Object System.Drawing.Size(200,200) 
$lijstexamens.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstexamens.DropDownStyle="DropDownList"

# uitvoeren als selectie van examens wijzigt
$lijstexamens.add_SelectedIndexChanged(
    {
    
    $listBox2.items.clear()
    $objtekst1.Visible = $false
    $Description7.Hide()

    $global:keuzeexamen = $lijstexamens.selecteditem
    
    Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen" -Name | ForEach-Object {[void] $listbox2.Items.Add($_)}

    startknopklikbaar;
    } )


startknopklikbaar;

$Form2.controls.AddRange(@($listBox, $lijstcrebonrs, $lijstkerntaken, $lijstexamens, $lijstlocaties, $listBox2, $Btnstart, $Btnescape, $objtekst1, $Description2, 
$Description3, $Description4, $Description5, $Description6, $Description7, $Description8 ))

#$form2.Topmost = $true
$form2.Topmost = $false

$null = $form2.ShowDialog()
    
$form2.close();
# $form2.hide();

# De hoofdmenu zichtbaar maken
$form.show()

}

function vensterbackup {

# variabelen
$keuzelocatie=$init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten" )) {
    $null = [System.Windows.Forms.MessageBox]::Show("De home-map van de studenten is niet gevonden!

Controleer of de volgende map aanwezig is :
$homemapstudenten
De taak kan nu niet opgestart worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}

if (!(test-path -path "$backupmap" )) {
    $null = [System.Windows.Forms.MessageBox]::Show("De backup-map is niet gevonden!

Controleer of de volgende map aanwezig is :
$backupmap
De taak kan nu niet opgestart worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,650)
$form2.text                       = "Backup van bestanden in de studentmappen"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Selecteer hieronder de rpc-nummers. Klik op Bevestigen om door te gaan."
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(20,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Kies eventueel als eerst je locatie."
$Description4.AutoSize            = $false
$Description4.width               = 300
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(280,50)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "backup" }) 
$Btnstart.Enabled= $false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel


# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,90)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 430

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$wissennabackup = New-Object System.Windows.Forms.Checkbox 
$wissennabackup.Location = New-Object System.Drawing.Point(50,580)
$wissennabackup.Size = New-Object System.Drawing.Size(500,30)
$wissennabackup.Text = "Bestanden na de backup ook wissen"

if (($init["algemeen"]["wissennabackup"]) -eq "ja") {
    $wissennabackup.checked = $true
    } else {
    $wissennabackup.checked = $false
    }

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,50) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$init["locaties"].keys | ForEach-Object {
    $waarde=$init["locaties"]["$_"]
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $wissennabackup, $Description3, $Description4 ))
$form2.Topmost = $false

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
}

function vensterwissen {

# variabelen
$keuzelocatie=$init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = [System.Windows.Forms.MessageBox]::Show("De home-map van de studenten is niet gevonden!

Controleer of de volgende map aanwezig is :
$homemapstudenten
De taak kan nu niet opgestart worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,650)
$form2.text                       = "Wissen van bestanden in de studentmappen"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Selecteer hieronder de rpc-nummers. Klik op Bevestigen om door te gaan."
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(20,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Kies eventueel als eerst je locatie."
$Description4.AutoSize            = $false
$Description4.width               = 300
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(280,50)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "wissen" }) 
$Btnstart.Enabled= $false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$form2.cancelbutton = $Btnescape

# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,90)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 430

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,50) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$init["locaties"].keys | ForEach-Object {
    $waarde=$init["locaties"]["$_"]
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $Description3, $Description4 ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdvenster zichtbaar maken
$form.show()
}

function vensterverplaatsen {

# variabelen
$keuzelocatie=$init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = [System.Windows.Forms.MessageBox]::Show("De home-map van de studenten is niet gevonden!

Controleer of de volgende map aanwezig is :
$homemapstudenten
De taak kan nu niet opgestart worden." , "Map bestaat niet",  "OK" , "Error")
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,350)
$form2.text                       = "Verplaatsen van bestanden naar een andere de studentmap"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Geef aan in welke rpc-nummer de bestanden staan, dit is de bron, 
en naar welke rpc-nummer de bestanden worden gekopierd, dit is het doel. 
Klik op Bevestigen om door te gaan."
$Description4.AutoSize            = $false
$Description4.width               = 580
$Description4.height              = 70
$Description4.location            = New-Object System.Drawing.Point(20,15)
$Description4.Font                = 'Microsoft Sans Serif,12'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Kies de bron :"
$Description2.AutoSize            = $false
$Description2.width               = 150
$Description2.height              = 50
$Description2.location            = New-Object System.Drawing.Point(20,140)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Kies het doel :"
$Description3.AutoSize            = $false
$Description3.width               = 150
$Description3.height              = 50
$Description3.location            = New-Object System.Drawing.Point(20,190)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Kies eventueel je locatie :"
$Description5.AutoSize            = $false
$Description5.width               = 300
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(20,90)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,300" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "verplaatsen" }) 
$Btnstart.Enabled= $false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,300" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$form2.cancelbutton = $Btnescape

# de selectie vd de bron
$bronselectie                     = New-Object system.Windows.Forms.ComboBox
$bronselectie.width               = 260
$bronselectie.autosize            = $true
$bronselectie.DropDownStyle       = "DropDownList"
$bronselectie.Font                = 'Microsoft Sans Serif,12'
$bronselectie.location = "200,140" 

$bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie

#  de selectie vd de doel rpc-nummer 
$doelselectie                     = New-Object system.Windows.Forms.ComboBox
$doelselectie.width               = 260
$doelselectie.autosize            = $true
$doelselectie.DropDownStyle       = "DropDownList"
$doelselectie.Font                = 'Microsoft Sans Serif,12'
$doelselectie.location = "200,190" 

$doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie


# start knop zichtbaar of niet bij bron- en doelselectie
# controle of dezelfde rpc-nr isgekozen

$doelselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $doelselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
    if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$bronselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $bronselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
     if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(200,90) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$init["locaties"].keys | ForEach-Object {
    $waarde=$init["locaties"]["$_"]
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie
     $doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

     # selectie van bron en doel ophefen
     $doelselectie.selecteditem = $null
     $bronselectie.selecteditem = $null

     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$kopiemaken = New-Object System.Windows.Forms.Checkbox 
$kopiemaken.Location = New-Object System.Drawing.Point(20,250)
$kopiemaken.Size = New-Object System.Drawing.Size(500,30)
$kopiemaken.Text = "Maak een kopie van de bestanden i.p.v. verplaatsen."
$kopiemaken.Font                = 'Microsoft Sans Serif,12'

$form2.controls.AddRange(@($lijstlocaties, $bronselectie, $doelselectie, $kopiemaken, $Btnstart, $Btnescape, $Description2, $Description3, $Description4, $Description5 ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
}

function programmaafsluiten {

$result = [System.Windows.Forms.MessageBox]::Show("U gaat het programma sluiten. Weet u het zeker?" , "Sluiten programma",  4 , "Question")
if ($result -eq 'Yes') {
    # programma sluiten
    $form.dispose()
}

}

function vensterlogbestand {

# controle of er logbestanden zijn
if (!(Test-Path -Path "$logmap\*.txt")) {
    $null = [System.Windows.Forms.MessageBox]::Show("Er zijn geen logbestanden om te weergeven" , "Geen logbestanden",  "OK" , "Stop")
    return;
    }

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(1100,650)
$form2.text                       = "Logbestanden bekijken"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Selecteer links de datum van het logbestand dat je wilt bekijken. 
Rechts wordt dan de inhoud weergegeven."
$Description1.AutoSize            = $false
$Description1.width               = 800
$Description1.height              = 42
$Description1.location            = New-Object System.Drawing.Point(20,15)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::Blue

$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,600" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'blue'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok

$listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(10,60)
$listBox2.Size = New-Object System.Drawing.Size(200,20)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.Height = 510

# bij aanklikken van een datum, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged( {
    $objtekst1.Text = ""
    # datum omzetten naar bestandsnaam
    $gekozendatum = bepaallognaam $ListBox2.SelectedItem
    # inhoud bestand inlezen
    $volledigetext = Get-Content -Path "$gekozendatum"
    # dan netjes in rijen plaatsen.
    foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + "$item" + "`r`n"
               }
    } )

# inhoud van logmap weergeven met listbox2
Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)
    }

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(230,60) 
$objtekst1.Size = New-Object System.Drawing.Size(800,504)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"

$Form2.Controls.AddRange(@($Description1, $Buttenok, $listbox2, $objtekst1 ))

# eerste logbestand is geselecteerd.
$listBox2.SelectedIndex = 0

$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()
}

function updatevoorbereiden ($opgestart) {

<# variabelen voor deze functie
 $opgestart geeft aan hoe dit is aangeroepen: auto of keuzemenu
#>

<# $huidigeversie wordt alleen in deze functie gebruikt en is er om te verduidelijken dat dit de huidge versie is en
   om niet overal "global:" voor te zetten. $versie is namelijk een global variabele.
#>
$huidigeversie = $global:versie

# updaten naar een versie. "uptodate" betekent geen update nodig, 
$updateto="uptodate"
# of deze versie verouderd is
$deprecated = $false
# pad naar updateinfo op lokale pc
$updateinfobestand = -join ("$startmap","\","$global:updateinfo")
# bepalen downloadbestand
$downloadbestand = -join ("$updatewebsite","/","$global:updateinfo")
# $autoupdate is afhankelijk van instelling in initialisatiebestand
if ($init["algemeen"]["autoupdate"] -eq "ja") {
    $autoupdate = $true 
    } else {
    $autoupdate = $false
    }

<# controleren of een update is uitgevoerd en zo ja verwijderen bestand
   zo kan ga je niet na een update, opnieuw updaten
   als je bent opgestart via hoofdvenster dan niet afsluiten
#>
if (test-path -path $updateinfobestand -pathtype leaf) { 
    Remove-Item "$updateinfobestand" 
    if ($opgestart -eq "begin")  { return }
    }

# downloaden updateinfobestand van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$updateinfobestand" -ErrorAction Stop
    }
catch {
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Bestand met update-informatie niet kunnen downloaden!  
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Bestand met update-informatie niet kunnen downloaden! "
        Start-Sleep -s 3
        }
    return
    }
      
# inlezen updateinfobestand en controleren op een update ...

# inlezen ini-bestand naar object
$global:updateini = Get-IniContent $updateinfobestand

# controleren of versie verouderd is
if ("$huidigeversie" -le $updateini["deprecated"]["old"]) { $deprecated = $true }

# controleren op revisie en anders op laatste versie 
if ($updateini["revision"].Contains($huidigeversie) ) {
    $updateto = $updateini["revision"]["$huidigeversie"]
    } else {
    
    if ("$huidigeversie" -lt $updateini["program"]["latest"]) {
        $updateto = $updateini["program"]["latest"]
        }
} 
# einde controles. er is bepaald of er een update is.

# programma is up to date?
if ($updateto -eq "uptodate") {

    Remove-Item "$updateinfobestand" 
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Het programma heeft de laatse versie." , "Geen update nodig",  "OK" , "Information") 
        }
    return
}

# Er is een update beschikbaar

# afhankelijk van opstartkeuze en autoupdate, melding geven of doorgaan.
if ($opgestart -eq "keuzemenu") {
    $result = [System.Windows.Forms.MessageBox]::Show("Er is een update voor dit programma.

Updaten naar versie $updateto ?" , "Update?",  "YesNo" , "Question") 

    if ($result -eq "No") { 
        Remove-Item "$updateinfobestand" 
        return 
        }
    } else {

    if (! ($autoupdate) ) { 
        Remove-Item "$updateinfobestand" 

        if ($init["algemeen"]["updatenotificatie"] -eq "ja" ) {

        if ($deprecated) {
            $messageboxtekst = "Er is een update beschikbaar.

Kies in het hoofdvenster 'Controleren op een update' 
of zet deze melding bij 'Instellingen' voortaan uit.
U wordt echter aangeraden deze te installeren omdat de huidige versie verouderd is."
            } else {
            $messageboxtekst = "Er is een update beschikbaar. 

Kies in het hoofdvenster 'Controleren op een update'
of zet deze melding bij 'Instellingen' voortaan uit."
            }
        $null = [System.Windows.Forms.MessageBox]::Show("$messageboxtekst" , "Update beschikbaar",  "OK" , "Information") 

        } # einde if $updateini["algemeen"]["updatenotificatie"]

        return
        } # einde if (! ($autoupdate) )
    } # einde if opgestart ... else

# variabelen die nodig zijn voor het downloaden. 
# bestand met update die gedownload wordt
$zip_download = "beherenbestanden_$updateto.zip"
# pad naar bestand met update op de website
$downloadbestand = bepaalversiemap "$updateto"
# pad naar bestand met update op de website, samenvoegen met update die gedownload wordt
$downloadbestand = -join ("$downloadbestand","/","$zip_download")
# pad naar bestand met update op lokale pc
$zip_download = -join ("$startmap","\","$zip_download")

# downloaden zip_download van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$zip_download" -ErrorAction Stop
    }
catch {
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Bestand met update niet kunnen downloaden! 
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Bestand met update niet kunnen downloaden! "
        Start-Sleep -s 3
        }
    return
    }

# tempmap aanmaken. als deze al bestaat wordt geen melding gegeven.
# vervolgens leeg maken
$tempmap = "$startmap\temp"

mkdir $tempmap -ErrorAction SilentlyContinue 1>$null
Remove-Item "$tempmap\*" -Recurse -Force 

# uitpakken van programma naar tempmap. alleen de updater is nu nodig.
Expand-Archive -Path "$zip_download" -DestinationPath "$tempmap" -Force

# zipbestand na het uitpakken direct verwijderen
Remove-Item "$zip_download"

# updater wordt nu geupdated

# kopiren updater en foutmeldingen opvangen
$error.clear()
try {
    Copy-Item -path "$tempmap\$updater" -destination "$startmap" -ErrorAction Stop
    }
catch {
    
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Fout tijdens het updaten.  Het bestand " + $updater + " is niet geupdated. 
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Fout tijdens het updaten. Het bestand " + $updater + " is niet geupdated."
        Start-Sleep -s 3
        }
    return
    }


# buttons sluiten. Anders krijg je een foutmelding bij script updater bij het kopieren van de map "png".
# de png-bestanden blijven namelijk nog in gebruik door powershell en de melding "icoon-backup.png is in use" verschijnt.
$Button1.Image.Dispose()
$Button2.Image.Dispose()
$Button3.Image.Dispose()
$Button4.Image.Dispose()
# $Button5.Image.Dispose()
$Button6.Image.Dispose()
$Button7.Image.Dispose()
$Button8.Image.Dispose()


# vensters sluiten

$form.Dispose()
$Form_opstart.dispose()

# opstarten updater
& "$PSScriptRoot\$updater"

# beindigen van programma als updaten in het begin is opgestart
if ($opgestart -eq "begin") {
    exit;
    } 

}


# initialiseren van programma ---------------------------------------------------------------

# controleren of initialisatie-bestand aanwezig is en inlezen bestand, anders bestand aanmaken

$opstartinfo.text = "Initialiseren ..."

# aanmaken initialisatiebestand met standaard inhoud
$global:init = standaardinstellingen

if (test-path -path $initbestand -pathtype leaf) { 
    # inlezen ini-bestand naar object
    $init = Get-IniContent $initbestand
    }


# einde intialiseren programma

# controleren op een update. alleen als hiervoor al geen update is uitgevoerd.

updatevoorbereiden ("begin");

# opstart venster sluiten voor het tonen van hoofdvenster
Start-Sleep -s 2
$Form_opstart.dispose()

# Form wordt getoond. dit is de hoofdvenster
$null = $Form.ShowDialog()
