<# 
Beherenbestanden.ps1

Programma om bestanden in studentmappen te beheren, dus bestanden klaarzetten, backuppen, verplaatsen of wissen.

Zie voor versienummer onder "Declareren variabelen".

Versienummer wordt volgens Semantic Versioning uitgevoerd (zie https://Semver.org)

Dit programma is beschermt met auteursplicht door middel van de GNU GPL (https://www.gnu.org/licenses)

Lees ook de readme.txt op https://neveshuis.nl/beherenbestanden/readme.txt
#>

# toevoegen .NET framework klassen ---------------------------------------------------------
Add-Type -AssemblyName PresentationFramework
Add-Type -AssemblyName System.Drawing
Add-Type -AssemblyName System.Windows.Forms

# VisualStyles aan zetten ------------------------------------------------------------------
[System.Windows.Forms.Application]::EnableVisualStyles()

<# Declareren variabelen ---------------------------------------------------------------------
   Bij functie standaardinstellingen onder sectie "Functions" staan de variabelen die door gebruikers
   gewijzigd kunnen worden #>

# versie van dit programma wordt weergegeven in de titel
[string]$global:Versie = "4.3.1"

<# Een extra label wordt weergegeven bij info over dit programma. 
   Een extra label kan een pre-release zijn of een build.
   Een pre-release wordt aangegeven met alpha.DATE (of beta.DATE) en een build met BUILDNUMBER.DATE 
   De BUILDNUMBER geeft aan hoe vaak het programma uitgebracht is. #>
[string]$extralabel = "alpha.230110"

# startmap met digitale bestanden
$digitalebestanden="B:\HR_TM_T2000\examendocumenten\digitale bijlagen"
# Om lokale testen uit te voeren wordt onderstaande 3 variabelen met een # ervoor gebruikt
# $digitalebestanden="C:\Users\$env:username\testwerking\digitale bijlagen"

# locatie van home-map van de studenten
$homemapstudenten="Y:\RPC"
# $homemapstudenten="C:\Users\$env:username\testwerking\doel"

# backupmap voor bewaren van kandidaatmappen
$backupmap="B:\HR_TM_T2000\backup kandidaten"
# $backupmap="C:\Users\$env:username\testwerking\backup kandidaten"

# startmap van het programma
$startmap=Split-Path -Parent $PSCommandPath

# map met png icoontjes
$icoontjesmap = -join ("$startmap","\","png")

# map voor logbestanden
$logmap = -join ("$startmap","\","log")

<# object met alle variabelen die in initialisatiebestand bewaard worden. Dit zijn de instellingen die gewijzigd kunnen worden.
   Zie ook functie standaardinstellingen onder sectie "Functions" #>
$Global:init=@{}

# locaties definiren
$PAL = @{
    naam = 'Prins Alexanderlaan'
    eerstenr = 1
    laatstenr= 60
}

$SHW = @{
    naam = 'Schiedamseweg'
    eerstenr = 131
    laatstenr= 180
}

$JLS = @{
    naam = 'Jan Ligthartstraat'
    eerstenr = 201
    laatstenr= 240
}

$global:locaties = @{
    PAL = $PAL
    SHW = $SHW
    JLS = $JLS
    }

# bestand met variabelen die gewijzigd kunnen worden en of extern bewaard moeten worden
$global:initbestand = "initialisatie.ini"
# volledige pad toevoegen aan variabele
$global:initbestand = -join ("$startmap","\","$global:initbestand")

# website met updates van programma
$updatewebsite = "https://neveshuis.nl/beherenbestanden"

# bestand met info over update. staat op de website
$global:updateinfo = "updateinfo.ini"

# script die het programma update. deze is in de root aanwezig.
$updater = "updater.ps1"

# de 2 bestanden met info voor venster informatieprogramma
$readmebestand="readme.txt"
$changelogbestand="changelog.txt"

# nodig voor werken met hashtabels. zie functies uitvoerentaken en overzichttaken
$uitvoeren = [hashtable]::Synchronized(@{})

# nodig voor informatie baloon 
$global:tooltip1 = New-Object System.Windows.Forms.ToolTip

# Einde declareren variabelen


# functions ---------------------------------------------------------------------------------
# hieronder de kleine functies die door andere functies gebruikt worden ---------------------

Function declareren_standaardvenster ($titel, $pos_x, $pos_y)
{
$StandaardForm                            = New-Object system.Windows.Forms.Form
# $StandaardForm.ClientSize                 = New-Object System.Drawing.Point($pos_x,$pos_y)
$StandaardForm.MaximumSize = New-Object System.Drawing.size($pos_x,$pos_y)
$StandaardForm.MinimumSize = New-Object System.Drawing.size($pos_x,$pos_y)
$StandaardForm.text                       = $titel
$StandaardForm.TopMost                    = $false
$StandaardForm.StartPosition              = 'CenterScreen'
$StandaardForm.BackColor = "white"
$StandaardForm.MaximizeBox = $False

return $StandaardForm
}


function bepaallognaam ($invoer)

{
<# de lognaam wordt bepaald adhv de invoer. dit is een datum in de format yyyy-mm-dd. Zie ook function Bepaaldatum.
   functie "bepaaldatumuitlognaam" doet het omgekeerde, dus een verandering hier moet ook in deze functie worden aangepast.
#>
$lognaam = -join ("$logmap","\log_","$invoer",".txt")

return $lognaam
}

function bepaaldatumuitlognaam ($invoer)
{
<# Uit de invoer wordt de datum bepaald. De format hiervoor staat in functie "bepaallognaam".
  Een wijziging in deze functie moet hier ook worden toegepast.
#>
$datumintekst = $invoer.substring(4, 10)
return $datumintekst
}

function bepaalversiemap ($invoer)
{
# bepaalt de map waar de versie in staat mbv de gegeven versie (invoer)

$major = $invoer.split('.')[0]
$minor = $invoer.split('.')[1]
$revision = $invoer.split('.')[2]

$versiemap = -join ("$updatewebsite","/updates/","$major",".","$minor" )
return $versiemap
}

function bepaaldatum {
# datum bepalen
$datumvandaag = get-date -Format "yyyy-MM-dd"
return $datumvandaag
}

function standaardinstellingen 
{
# hier worden de standaard instellingen gedeclareerd die gebruikers kunnen wijzigen


$algemeen=@{
    locatiekeuze = 'PAL'
    autoupdate = 'Ja'
    wissennabackup = 'Ja'
    updatenotificatie = 'Ja'
    maplegenvoorverplaatsen = 'Ja'
}

$opschonen=@{
    dagenbewarenbackup = 730
    dagenbewarenlogs = 365
    opschonenlogs = 'Ja'
}

$Std_inst=@{
    algemeen=$algemeen
    opschonen=$opschonen
}

return $Std_inst
}

function Get-IniContent ($filePath)
{
# Leest een bestand met instellingen en geeft deze terug als een array
    $ini = @{}
    switch -regex -file $FilePath
    {
        ^\[(.+)\] # Section
        {
            $section = $matches[1]
            $ini[$section] = @{}
            $CommentCount = 0
        }
        ^(;.*)$ # Comment
        {
            $value = $matches[1]
            $CommentCount = $CommentCount + 1
            $name = Comment + $CommentCount
            $ini[$section][$name] = $value
        }
        (.+?)\s*=(.*) # Key
        {
            $name,$value = $matches[1..2]
            $ini[$section][$name] = $value
        }
    }
    return $ini
}


function declareren_rpcnrs {

# Venster voor weergeven rpcnummer declareren. Wordt bij meerdere functies gebruikt.

$listbox_temp = New-Object System.Windows.Forms.Listbox
$listbox_temp.Location = New-Object System.Drawing.Point(10,40)
$listbox_temp.Size = New-Object System.Drawing.Size(150,20)
$listbox_temp.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listbox_temp.SelectionMode = 'MultiExtended'
$listbox_temp.Height = 500

return $listbox_temp
}

function lijstrpcnrsaanmaken ($keuzelocatie, $listbox_temp) {
# een lijst met rpc-nummers wordt gemaakt adhv gekozen locatie

# lijst wordt leeggemaakt
$listbox_temp.Items.Clear()

# waarden uit array halen die nodig zijn om lijst te maken met rpc-nummers
[int]$keuzeeerstenr=$global:locaties["$keuzelocatie"]["eerstenr"]
[int]$keuzelaatstenr=$global:locaties["$keuzelocatie"]["laatstenr"]

#listbox items aanmaken
For ($i=$keuzeeerstenr; $i -le $keuzelaatstenr; $i++) {

    if ($i -lt 10) {$rpcnr="RPC-00"+"$i"}
    elseif ($i -lt 100) {$rpcnr="RPC-0"+"$i"}
    else {$rpcnr="RPC-"+"$i"}
    [void] $listbox_temp.Items.Add($rpcnr)
}

return $listbox_temp
}

function vraagvenster ($titel, $vraag, $knopok, $knopannuleren)  {

# venster declareren
$formvraag = declareren_standaardvenster $titel 600 200

$vraaglabel                     = New-Object system.Windows.Forms.Label
$vraaglabel.text                = $vraag
$vraaglabel.AutoSize            = $false
$vraaglabel.width               = 550
$vraaglabel.height              = 100
$vraaglabel.location            = New-Object System.Drawing.Point(20,10)
$vraaglabel.Font                = 'Microsoft Sans Serif,11'
$vraaglabel.ForeColor = [System.Drawing.Color]::Blue
$formvraag.Controls.Add($vraaglabel)

# knop ok wordt altijd weergegeven. knop annuleren alleen als een 2e knop-naam gegeven is.
$vraagok = New-object System.Windows.Forms.Button 
if (!($knopok -eq $null) ) { 
    $vraagok.text= $knopok
} else {
    $vraagok.text= "Ok"
}
# $vraagok.location = "50,130" 
$vraagok.location = New-Object System.Drawing.Point(50,120)
$vraagok.size = "150,30"  
if ($vraagok.text -eq "Ok") { $vraagok.BackColor = 'blue' }
   else { $vraagok.BackColor = 'green' }
$vraagok.ForeColor = 'white'
$vraagok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$formvraag.Controls.Add($vraagok)


if (!($knopannuleren -eq $null) ) { 
$vraagescape = New-object System.Windows.Forms.Button 
$vraagescape.text= $knopannuleren
$vraagescape.location = "250,120" 
$vraagescape.size = "150,30"  
$vraagescape.BackColor = 'red'
$vraagescape.ForeColor = 'white'
$vraagescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$formvraag.Controls.Add($vraagescape)
}

#$formvraag.controls.AddRange(@($vraaglabel, $vraagok, $vraagescape ))

$result = $formvraag.ShowDialog()
    
$formvraag.close();

return $result
}

Function declareren_uitlegvenster ($titel, $size_x, $size_y, $icoon_x, $icoon_y, $tekst) {
<# 
Hiermee kan je mbv een vraagteken in een venster extra uitleg geven.
variabele titel wordt als titel weergegeven.
variabele size_x en size_y geven de grootte vh venster op.
variabele icoon_x en icoon_y de positie van de vraagteken.
variabele tekst is de weer te geven informatietekst.
#>

# benodigde venster declareren
$Global:Form_uitleg_taak                    = New-Object system.Windows.Forms.Form
$Global:Form_uitleg_taak.StartPosition      = 'CenterScreen'
$Global:Form_uitleg_taak.BackColor          = "white"
$Global:Form_uitleg_taak.TopMost            = $true
$Global:Form_uitleg_taak.MaximumSize        = New-Object System.Drawing.size($size_x,$size_y)
$Global:Form_uitleg_taak.MinimumSize        = New-Object System.Drawing.size($size_x,$size_y)
$Global:Form_uitleg_taak.text               = $titel
$Global:Form_uitleg_taak.ControlBox         = $False

[int]$tekst_x = $size_x -10
[int]$tekst_y = $size_y -85

$Global:uitlegtaaktekst                     = New-Object system.Windows.Forms.Label
$Global:uitlegtaaktekst.AutoSize            = $false
$Global:uitlegtaaktekst.location            = New-Object System.Drawing.Point(10,10)
$Global:uitlegtaaktekst.Font                = 'Microsoft Sans Serif,11'
$Global:uitlegtaaktekst.ForeColor = [System.Drawing.Color]::blue
$Global:uitlegtaaktekst.text                = $tekst
$Global:uitlegtaaktekst.width               = $tekst_x
$Global:uitlegtaaktekst.height              = $tekst_y

$Global:Form_uitleg_taak.Controls.Add($Global:uitlegtaaktekst)

[int]$knop_x = 250
[int]$knop_y = $size_y -75

$knopsluiten = New-object System.Windows.Forms.Button 
$knopsluiten.text= 'Sluiten'
$knopsluiten.location = New-Object System.Drawing.size($knop_x,$knop_y)
$knopsluiten.size = "150,30"  
$knopsluiten.BackColor = 'red'
$knopsluiten.ForeColor = 'white'
$knopsluiten.DialogResult = [System.Windows.Forms.DialogResult]::ok

$Global:Form_uitleg_taak.Controls.Add($knopsluiten)

# vraagteken weergeven om extra info te geven.
$Global:vraagtekenicoon                     = new-object Windows.Forms.PictureBox
$Global:vraagtekenicoon.Location            = New-Object System.Drawing.Size($icoon_x, $icoon_y)
$Global:vraagtekenicoon.Size                = New-Object System.Drawing.Size(30,60)
$Global:vraagtekenicoon.Image               = [System.Drawing.Image]::FromFile("$icoontjesmap\icoon-hulp.png")
$Global:vraagtekenicoon.add_click( { $Global:Form_uitleg_taak.showdialog() } )
$Global:vraagtekenicoon.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Klik hier voor uitleg over de taak." )
})
# $Global:vraagtekenicoon.add_MouseLeave( { $Global:Form_uitleg_taak.hide() } )

} # einde declareren_uitlegvenster



# hieronder de hoofdfuncties ----------------------------------------------------------------



function scriptRun {

function backup_mapcontrole ([string]$rpcnummer)

{
<# Deze procedure wordt gebruikt bij functie uitvoerentaken.
   Bij de taak backup van functie uitvoerentaken wordt gecontroleerd of al een backup is gemaakt.
   als dit zo is wordt bij deze functie een keuze gegeven wat ermee te doen.
#>

# antwoord als op kruis wordt geklikt
$antwoordvraag = "overslaan"

$Form4                            = New-Object system.Windows.Forms.Form
# $Form4.ClientSize                 = New-Object System.Drawing.Point(600,250)
$Form4.MaximumSize                = New-Object System.Drawing.size(650,270)
$Form4.MinimumSize                = New-Object System.Drawing.size(650,270)
$Form4.text                       = "Backup van studentmap is al gemaakt."
$Form4.TopMost                    = $false
$Form4.StartPosition              = 'CenterScreen'
$Form4.ControlBox                 = $False
$Form4.BackColor                  = 'white'

$uitleg_mapcontrole               = New-Object system.Windows.Forms.Label
$uitleg_mapcontrole.AutoSize      = $false
$uitleg_mapcontrole.Text          = "Een backup van studentmap $rpcnummer is al gemaakt.
Geef aan wat u hiermee wilt doen."
$uitleg_mapcontrole.width         = 500
$uitleg_mapcontrole.height        = 40
$uitleg_mapcontrole.location      = New-Object System.Drawing.Point(20,10)
$uitleg_mapcontrole.Font          = 'Microsoft Sans Serif,11'
$uitleg_mapcontrole.ForeColor     = 'blue'

$keuze1_mapcontrole = New-Object System.Windows.Forms.Button
$keuze1_mapcontrole.Location = New-Object System.Drawing.Size(20, 60)
$keuze1_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze1_mapcontrole.Text = "Verwijderen"
$keuze1_mapcontrole.height = 40
$keuze1_mapcontrole.BackColor = 'green'
$keuze1_mapcontrole.ForeColor = 'white'
$keuze1_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::Yes

$keuze2_mapcontrole = New-Object System.Windows.Forms.Button
$keuze2_mapcontrole.Location = New-Object System.Drawing.Size(20, 120)
$keuze2_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze2_mapcontrole.Text = "Behouden"
$keuze2_mapcontrole.height = 40
$keuze2_mapcontrole.BackColor = 'green'
$keuze2_mapcontrole.ForeColor = 'white'
$keuze2_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::Ignore


$uitleg1_vraag               = New-Object system.Windows.Forms.Label
$uitleg1_vraag.AutoSize      = $false
$uitleg1_vraag.Text          = "Bestaande backup wordt verwijderd en een nieuwe backup wordt gemaakt."
$uitleg1_vraag.width         = 440
$uitleg1_vraag.height        = 40
$uitleg1_vraag.location      = New-Object System.Drawing.Point(160,60)
$uitleg1_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg1_vraag.ForeColor     = 'blue'

$uitleg2_vraag               = New-Object system.Windows.Forms.Label
$uitleg2_vraag.AutoSize      = $false
$uitleg2_vraag.Text          = "Bestaande backup wordt behouden. Er wordt geen nieuwe backup gemaakt."
$uitleg2_vraag.width         = 440
$uitleg2_vraag.height        = 40
$uitleg2_vraag.location      = New-Object System.Drawing.Point(160,120)
$uitleg2_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg2_vraag.ForeColor     = 'blue'


$optieherhalen = New-Object System.Windows.Forms.Checkbox 
$optieherhalen.Location = New-Object System.Drawing.Point(20,170)
$optieherhalen.Size = New-Object System.Drawing.Size(500,30)
$optieherhalen.Text = "Deze keuze herhalen voor alle studentmappen waarvan een backup is gemaakt."
$optieherhalen.checked = $false
$optieherhalen.Font = 'Microsoft Sans Serif,11'
$optieherhalen.ForeColor     = 'green'
$optieherhalen.height = 50

$form4.controls.AddRange(@($uitleg_mapcontrole, $uitleg1_vraag, $uitleg2_vraag, $keuze1_mapcontrole, $keuze2_mapcontrole, $optieherhalen ))
$form4.Topmost = $false

$result = $form4.ShowDialog()

if ($result -eq [system.windows.forms.dialogResult]::Yes) {
    $antwoordvraag = "wissen"
    } else {
    $antwoordvraag = "overslaan"
    }

# variabelen teruggeven
return $antwoordvraag, $optieherhalen.checked
}


# nodig voor afhandelen foutmeldingen
$uitvoeren.foutmelding = $false

# nodig om in logbestand te schrijven
$logbestand = $uitvoeren.logbestand

# datum van vandaag. nodig bij taak backup.
$datumvandaag = get-date -Format "yyyy-MM-dd"

# hier wordt de taak uitgevoerd.
switch ($uitvoeren.taak) {

    "backup"   { 

    # variabele keuzeherhalen kan "true" worden bij functie backup_mapcontrole
    # standaard wordt de keuze niet herhaald
    $keuzeherhalen = $false

    #kopiren bestanden naar studentmappen
    foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()
        
        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ $rpcitem - FOUT ] : "
        $infomelding_log = "[ $rpcitem - INFO ] : "

        # bepalen bronmap. dit is de homemap van de kandidaten
        $bronmap = -join ($uitvoeren.homemap,'\',$rpcitem)

        # bepalen doelmap. dit is de map waar de backup in komt.
        $doelmap = -join ($uitvoeren.doelmap,'\',$datumvandaag,'\',$rpcitem)

        <# variabele nodig voor backuptaak
           standaard wordt kopieren uitgevoerd
        #>
        $uitvoerenwissen = $false
        $uitvoerenbackup = $true
        
        # controleren of backup voor deze rpcnr al gemaakt is, door map op inhoud te controleren
        if (test-path "$doelmap\*" ) {

            "$infomelding_log" + "Er is al een backup gemaakt van deze studentmap. " | out-file "$logbestand" -Append

            # controleren of er is gekozen om keuze te herhalen
            if (!($keuzeherhalen)) {

            # vragen wat te doen met bestanden in map
            $antwoordvraag, $keuzeherhalen = backup_mapcontrole "$rpcitem"
            if ($antwoordvraag -eq "wissen") { 
                $uitvoerenwissen = $true 
                "$infomelding_log" + "U heeft gekozen de oude backup te verwijderen. " | out-file "$logbestand" -Append
                }
            if ($antwoordvraag -eq "overslaan") { 
                $uitvoerenbackup = $false 
                "$infomelding_log" + "U heeft gekozen de oude backup te behouden. " | out-file "$logbestand" -Append
                }
            if ($keuzeherhalen) {
                # onthouden van keuzes
                $onthoudkeuzewissen = $uitvoerenwissen
                $onthoudkeuzebackup = $uitvoerenbackup
                "$infomelding_log" + "U heeft gekozen deze actie te herhalen bij andere studentmappen. " | out-file "$logbestand" -Append
                                }
            } else {
            # de keuze die is gemaakt wordt herhaald
                $uitvoerenwissen = $onthoudkeuzewissen
                $uitvoerenbackup = $onthoudkeuzebackup
                
            } # einde if not keuzeherhalen
        } # einde controleren of backup voor deze rpcnr al gemaakt is

        # als bestaande backup moeten worden gewist. 
        # Dit stukje is hetzelde als bij keuze "wissen" van deze switch-commando
        if ($uitvoerenwissen) {
            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "\\?\$doelmap" -Recurse -Force -ErrorAction Stop

                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
        } # einde if uitvoerenwissen

        if ($uitvoerenbackup) {
            $error.clear()
            try {
                #backup maken
                Copy-Item -path "\\?\$bronmap" -destination "\\?\$doelmap" -recurse -Force -container -ErrorAction Stop

                # en daarna wissen als dit geselecteerd is
                if ($uitvoeren.wissennabackup -eq $true) { 
                    # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                    Remove-Item "\\?\$bronmap\mijn documenten\*" -Recurse -Force -ErrorAction Stop
                    # dan de root van rpc-map exclusief map mijn documenten
                    Remove-Item "\\?\$bronmap\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                    }
                } # einde try

            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch

        } # einde if uitvoerenbackup

    } # einde foreach rpcitem

               } # einde taak backup

    "kopiren" { 

    # array aanmaken en vullen met geselecteerde items. 
    # Deze items worden vervolgens gekopierd.
    $geselecteerdeitems = [System.Collections.ArrayList]@()

    <# Als er geen items zijn geselecteerd in de examenmap dan moet de gehele map worden gekopierd.
   hiervoor wordt dan de pad naar de examenmap toegevoegd aan de array $geselecteerdeitems.
   anders worden de geselecteerde items toegevoegd aan de array.
    #>
    if ($uitvoeren.listbox2.selecteditems.count -eq 0) {
        $bronmap = -join ($uitvoeren.bronmap,'\*')
        $geselecteerdeitems.Add("$bronmap")
        } else {
        foreach ($item in $uitvoeren.listbox2.selecteditems) {
            $bronmap = -join ($uitvoeren.bronmap,'\',$item)
            $geselecteerdeitems.Add("$bronmap")
        }
    }

    #kopiren bestanden naar studentmappen

    foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()

        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ $rpcitem - FOUT ] : "

        # doelmap bepalen. dit is een lokale variabele
        $doelmap = -join ($uitvoeren.homemap,'\',$rpcitem,'\Mijn Documenten')
    
        # kopieren geselecteerde mappen of bestanden
            
        foreach ($item in $geselecteerdeitems) {
        $error.clear()
        try {
             Copy-Item -path "$item" -destination "$doelmap" -recurse -Force -ErrorAction Stop
            }

        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
            $uitvoeren.foutmelding = $true
              } # einde catch
            } # einde foreach $item
        
    } # einde foreach $rpcitem

    # array legen. mss is dit niet nodig!
    $geselecteerdeitems.Clear()
    # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
    $uitvoeren.listbox.selecteditems.clear()

               } # einde taak kopiren

    "wissen"   { 
        #wissen van bestanden in studentmappen
        foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
            # progressie laten zien op balk
            $uitvoeren.progressbar.PerformStep()

            # teksten met meldingen voor het logbestand
            $foutmelding_log = "[ $rpcitem - FOUT ] : "
            $infomelding_log = "[ $rpcitem - INFO ] : "
            
            # doelmap bepalen. dit is een lokale variabele voor de deel-functie wissen hieronder.
            $doelmap = -join ($uitvoeren.homemap,'\',$rpcitem,'\Mijn Documenten')
            $doelmaproot = -join ($uitvoeren.homemap,'\',$rpcitem)

            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "\\?\$doelmap\*" -Recurse -Force -ErrorAction Stop
                # dan de root van rpc-map exclusief map mijn documenten
                Remove-Item "\\?\$doelmaproot\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
            
            } # einde foreach statement

               } # einde taak wissen

    "verplaatsen" {
        # er is maar een actie te doen dus...
        $uitvoeren.progressbar.maximum = 1

        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ FOUT ] : "

        # definiren bron- en doelmap
        $bronmap = $uitvoeren.bronmap
        $doelmap = $uitvoeren.doelmap

        # doelmap wordt geleegd voor het verplaatsen of kopiren, als dit gekozen is.
        if ($uitvoeren.doelmaplegen -eq $true) {
            $error.clear()
            try {
                # verwijderen van bestanden in doelmap
                Remove-Item "\\?\$doelmap\*" -Recurse -Force -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
        }

        # kopieren of verplaatsen
        $error.clear()
        try {
            # eerst kopiren
            Copy-Item -path "\\?\$bronmap" -destination "\\?\$doelmap" -recurse -ErrorAction Stop

            # verwijderen van bestanden als keuze is verplaatsen. alleen de inhoud van mijn documenten
            if ($uitvoeren.keuzeverplaatsen -eq "verplaatsen") {
                Remove-Item "\\?\$bronmap" -Recurse -Force -ErrorAction Stop
                }
            }
        catch {
              
              $uitvoeren.foutmelding = $true
              # foutmelding van PowerShell naar logbestand
              "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
              
              } # einde catch

        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()

                  } # einde taak verplaatsen

} # einde switch commando $uitvoeren.taak

} # einde scriptRun

function uitvoerentaken {
# hier worden de 4 belangrijkste taken uitgevoerd.

# controleren of mappen bestaan - afhankelijk van de taak
# map uitvoeren.homemap wordt in ieder geval gecontroleerd

if (!(test-path -path $uitvoeren.homemap -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De homemappen van de studenten zijn niet gevonden!
Controleer of de volgende map aanwezig is :
- $uitvoeren.homemap

De taak kan nu niet uitgevoerd worden." "OK"
    return;
} # einde test voor map uitvoeren.homemap

if ($uitvoeren.taak -eq "kopiren") {
if (!(test-path -path $digitalebestanden -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De map met de te kopiren bestanden is niet gevonden!
Controleer of de volgende map aanwezig is :
- $digitalebestanden

De taak kan nu niet uitgevoerd worden." "OK"
    return;
}
} # einde test voor map digitalebestanden

if ($uitvoeren.taak -eq "backup") {
if (!(test-path -path $backupmap -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De backupmap is niet gevonden!
Controleer of de volgende map aanwezig is :
- $backupmap

De taak kan nu niet uitgevoerd worden." "OK"
    return;
}
} # einde test voor map backupmap

# einde controleren of mappen bestaan

# startknop wordt onzichtbaar
$StartButton.Hide()
$Btnescape.Hide()


# het proces zichtbaar maken in een balk
$uitvoeren.progressbar = New-Object System.Windows.Forms.ProgressBar
$uitvoeren.progressbar.Location = New-Object System.Drawing.Point(20, 40)
$uitvoeren.progressbar.Size = New-Object System.Drawing.Size(560, 30)
$uitvoeren.progressbar.Style = "continuous"
# aantal geselecteerde rpcnrs bepaalt de maximumwaarde van de progressbar
$uitvoeren.progressbar.maximum = $listbox.selecteditems.count
$uitvoeren.progressbar.step = 1

# ProgressBar toevoegen aan form3
$uitvoeren.form3.Controls.Add($uitvoeren.progressbar);

# teksten en progressbar veranderen
$Label.hide()
$Description3.hide()
$Description2.ForeColor = 'green'
$Description2.Text = "De taak wordt uitgevoerd ..."
$uitvoeren.progressbar.visible

# datum bepalen
$datumvandaag = bepaaldatum;

# logbestandsnaam definiren en volledige pad naar bestand invoeren
# $logbestand = -join ("$logmap","\log_","$datumvandaag",".txt")
$logbestand = bepaallognaam "$datumvandaag"

# doorgeven aan hastable uitvoeren
$uitvoeren.logbestand = $logbestand

# starttijd van loggen naar variabele
$logtijd = get-date -Format "HH:mm:ss"

# map aanmaken voor logbestanden als deze niet bestaat
if (!(Test-Path "$logmap")) { mkdir "$logmap" } 

# in logbestand info over de taak schrijven en beginnen met uitvoeren van taak ---------------------------

"De taak " + $uitvoeren.taak + " is uitgevoerd." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append
$objtekst1.Text | out-file $logbestand -Append
if ($uitvoeren.taak -eq "kopiren") {
    $objtekst2.Text | out-file $logbestand -Append
    } elseif ($uitvoeren.taak -eq "backup") {
    if ($wissennabackup.checked -eq $true) { "De bestanden worden na de backup gewist." | out-file $logbestand -Append }
    } elseif ($uitvoeren.taak -eq "verplaatsen") {
    if ($keuzeoptie1.Selectedindex -eq "1") { 
        "U gaat bestanden kopiren van een rpc-nummer naar een andere." | out-file $logbestand -Append
        } else {
        "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." | out-file $logbestand -Append
        }
     if ($doelmaplegen.checked -eq $true) { 
        "De doelmap wordt voor het verplaatsen of kopiren eerst geleegd." | out-file $logbestand -Append
                    } else {
        "De bestanden worden toegevoegd aan de bestanden in de doelmap." | out-file $logbestand -Append
                    }
    }


# ------ begin runspaces ----------------------------------------------

#Configure max thread count for RunspacePool.
$maxthreads = [int]$env:NUMBER_OF_PROCESSORS
    
#Create a new session state for parsing variables ie hashtable into our runspace.
$hashVars = New-object System.Management.Automation.Runspaces.SessionStateVariableEntry -ArgumentList 'uitvoeren',$uitvoeren,$Null
$InitialSessionState = [System.Management.Automation.Runspaces.InitialSessionState]::CreateDefault()
    
#Add the variable to the RunspacePool sessionstate
$InitialSessionState.Variables.Add($hashVars)

#Create our runspace pool. We are entering three parameters here min thread count, max thread count and host machine of where these runspaces should be made.
$script:runspace = [runspacefactory]::CreateRunspacePool(1,$maxthreads,$InitialSessionState, $Host)

#Create a PowerShell instance.
$script:powershell = [powershell]::Create()
    
#Open a RunspacePool instance.
$script:runspace.Open()
         
#Add our main code to be run via $scriptRun within our RunspacePool.
$script:powershell.AddScript(${Function:scriptRun})
$script:powershell.RunspacePool = $script:runspace
        
#Run our RunspacePool.
$script:handle = $script:powershell.BeginInvoke()

#Wait for code to complete and keep UI responsive
do {
		[System.Windows.Forms.Application]::DoEvents()
		Start-Sleep -Milliseconds 1 
} while (!$script:handle.IsCompleted)

#Cleanup our RunspacePool threads when they are complete ie. GC.
if ($script:handle.IsCompleted)
        {
            $script:powershell.EndInvoke($script:handle)
            $script:powershell.Dispose()
            $script:runspace.Dispose()
            $script:runspace.Close()
            [System.GC]::Collect()
        }

# ----- Einde runspaces -----------------------------------------------

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
$logtijd = get-date -Format "HH:mm:ss"


"" | out-file $logbestand -Append
"Eindtijd  : $logtijd" | out-file $logbestand -Append
" -------------------------------------------------------------------------" | out-file $logbestand -Append
"" | out-file $logbestand -Append

# aangeven dat taken zijn uitgevoerd 
if ($uitvoeren.foutmelding) { 
    $Description2.ForeColor = 'red'
    $Description2.Text = "De taak is niet correct uitgevoerd. Bekijk de foutmeldingen in het logbestand."
    } else { $Description2.Text = "De taak is uitgevoerd." }

# knoppen zichtbaar maken
$EndButton.show()
$LogButton.show()

# alleen bij taak kopieren onderstaande knop zichtbaar maken
if ($uitvoeren.taak -eq "kopiren") {
    $Btnescape.size = New-Object System.Drawing.Size(200,40)
    # escape knop wordt nu opnieuw knop
    $Btnescape.text= "Opnieuw bestanden klaarzettenn"
    $Btnescape.BackColor = 'green'
    $Btnescape.show()
    $form2.show()
} else {
# knop logbestand bekijken wordt nu naar links verplaatst om aan te sluiten met knop sluiten.
$LogButton.Location = New-Object System.Drawing.Size(160, 400)
}

} # einde uitvoerentaken

function overzichttaken ([string]$taak) {
# na het bevestigen van je keuze bij een van de 4 taken kom je bij deze functie.
# hier zie je een overzicht en kan je de taak starten of nog terug.

# hashtable object leeg maken voor het geval het nog waarden heeft.
$uitvoeren.clear()

# definiren venster
$uitvoeren.Form3 = declareren_standaardvenster "Overzicht uit te voeren taak" 600 500

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.AutoSize            = $false
$Description2.width               = 570
$Description2.height              = 20
$Description2.location            = New-Object System.Drawing.Point(20,10)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor           = 'blue'

# onderstaande tekst wordt alleen zichtbaar als backuptaak is gekozen en wissen na backup is geselecteerd.
$Description3                     = New-Object system.Windows.Forms.Label
$Description3.AutoSize            = $false
$Description3.width               = 500
$Description3.height              = 20
$Description3.location            = New-Object System.Drawing.Point(20,28)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.Text                = "De bestanden worden na de backup gewist."
$Description3.ForeColor           = 'blue'
$Description3.hide()

$StartButton = New-Object System.Windows.Forms.Button
$StartButton.Location = New-Object System.Drawing.Size(10, 400)
$StartButton.Size = New-Object System.Drawing.Size(120, 50)
$StartButton.Text = "Start"
$StartButton.height = 40
$StartButton.BackColor = 'green'
$StartButton.ForeColor = 'white'
$StartButton.Add_click( {
    # toevoegen object en variabelen aan hastable voor uitvoeren 
    $uitvoeren.taak=$taak
    $uitvoeren.logbestand=$logbestand
    $uitvoeren.homemap=$homemapstudenten
    $uitvoeren.listbox = New-Object System.Windows.Forms.Listbox
    $uitvoeren.listbox = $listbox

    <# specifieke variabelen voor de gegeven taak.
       o.a. toevoegen tekst aan variabele uitvoeren.logbestandtekst om in logbestand te plaatsen
    #>
    switch ($taak) {

        "kopiren" {
        $uitvoeren.listbox2 = New-Object System.Windows.Forms.Listbox
        $uitvoeren.listbox2 = $listbox2
        $uitvoeren.bronmap = -join ($digitalebestanden,"\",$keuzecrebonr,"\",$keuzekerntaak,"\",$keuzeexamen)
        # $uitvoeren.logbestandtekst = $uitvoeren.logbestandtekst + "`r`n" + $objtekst2.Text
        }

        "backup" {
        $uitvoeren.doelmap="$backupmap"
        $uitvoeren.wissennabackup=$wissennabackup.checked
        }

        "verplaatsen" {
        # bepalen doel-, bronmap en doelmaplegen
        $uitvoeren.bronmap = -join ($homemapstudenten,"\",$bronselectie.selecteditem,"\Mijn Documenten\*")
        $uitvoeren.doelmap = -join ($homemapstudenten,"\",$doelselectie.selecteditem,"\Mijn Documenten")
        $uitvoeren.doelmaplegen=$doelmaplegen.checked
        # keuze tussen kopieren of verplaatsen doorgeven
        if ($keuzeoptie1.Selectedindex -eq "1") { 
                    $uitvoeren.keuzeverplaatsen = "kopiren" 
                    } else {
                    $uitvoeren.keuzeverplaatsen = "verplaatsen" 
                    }
        }
    } # einde switch $taak

    $form2.hide()

    uitvoerentaken;
    
    });

$EndButton = New-Object System.Windows.Forms.Button
$EndButton.Location = New-Object System.Drawing.Size(10, 400)
$EndButton.Size = New-Object System.Drawing.Size(120, 50)
$EndButton.Text = "Sluiten"
$EndButton.height = 40
$EndButton.BackColor = 'red'
$EndButton.ForeColor = 'white'
$EndButton.DialogResult = [System.Windows.Forms.DialogResult]::OK
$EndButton.hide()

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Terug"
$Btnescape.location = New-Object System.Drawing.Size(160, 400)
$Btnescape.size = New-Object System.Drawing.Size(120, 50)
$Btnescape.height = 40
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

$LogButton = New-Object System.Windows.Forms.Button
$LogButton.Location = New-Object System.Drawing.Size(400, 400)
$LogButton.Size = New-Object System.Drawing.Size(170, 50)
$LogButton.Text = "Logbestand bekijken"
$LogButton.height = 40
$LogButton.BackColor = 'blue'
$LogButton.ForeColor = 'white'
$LogButton.hide()
$LogButton.add_click({ 
    $Form2.dispose()
    $uitvoeren.Form3.dispose()

    vensterlogbestand })

$Label = New-Object System.Windows.Forms.Label
$Label.Font = 'Microsoft Sans Serif,12'
$Label.ForeColor = 'blue'
$Label.Text = "Klaar om de taak uit te voeren ?"
$Label.Location = New-Object System.Drawing.Point(20, 50)
$Label.Width = 480
$Label.Height = 20

switch ($taak) {
    "backup"      { 
                  $Description2.text = "U gaat een backup uitvoeren op de volgende rpc-nummers." 
                  if ($wissennabackup.checked -eq $true) { 
                    $Description3.text = "De bestanden worden na de backup gewist."
                    $Description3.show() 
                    }
                  }
    "kopiren"    { $Description2.text = "U gaat bestanden of mappen klaarzetten op de volgende rpc-nummers." }
    "wissen"      { $Description2.text = "U gaat bestanden wissen van de volgende rpc-nummers." }
    "verplaatsen" { 
                  if ($keuzeoptie1.Selectedindex -eq "1") { 
                    $Description2.text = "U gaat bestanden kopiren van een rpc-nummer naar een andere." 
                    } else {
                    $Description2.text = "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." 
                    }
                  $Description3.show() 
                  if ($doelmaplegen.checked -eq $true) { 
                    $Description3.text = "De doelmap wordt voor het verplaatsen of kopiren eerst geleegd."
                    } else {
                    $Description3.text = "De bestanden worden toegevoegd aan de bestanden in de doelmap."
                    }
                  }
}

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,80) 
$objtekst1.Size = New-Object System.Drawing.Size(200,290)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = "Geselecteerde rpc-nummers:" + "`r`n" + "`r`n"
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'

$objtekst2 = New-Object System.Windows.Forms.textbox
$objtekst2.Location = New-Object System.Drawing.Size(230,80) 
$objtekst2.Size = New-Object System.Drawing.Size(350,290)
$objtekst2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst2.Text = ""
$objtekst2.ReadOnly = $true
$objtekst2.Multiline = $true
$objtekst2.ScrollBars = "Both"
$objtekst2.Visible = $false
$objtekst2.BackColor  = 'white'

# geselecteerde rpc-nummers links weergeven
# als taak is verplaatsen heb je een andere inhoud dan bij overige taken
if ($taak -eq "verplaatsen") {
    $objtekst1.Text = $objtekst1.Text + " Bron is " + $bronselectie.selecteditem + "`r`n" + "`r`n"
    $objtekst1.Text = $objtekst1.Text + " Doel is " + $doelselectie.selecteditem + "`r`n"
    } else {
    foreach ($item in $listbox.selecteditems) {
        $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
        }
    }

# geselecteerde mappen bij taak kopiren rechts weergeven. alleen als taak kopieren is geslecteerd
if ($taak -eq "kopiren") {
    $objtekst2.Text = "Geselecteerde bestanden of mappen:" + "`r`n" + "`r`n"
    $objtekst2.Visible = $true

    if ($listbox2.selecteditems.count -eq 0) {
        $objtekst2.Text = $objtekst2.Text + " - " + "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen" + "`r`n"

        } else {
        foreach ($item in $listbox2.selecteditems) {
            $objtekst2.Text = $objtekst2.Text + " - " + "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\$item" + "`r`n"
            }
        }
    }

$uitvoeren.Form3.Controls.AddRange(@($Description2, $Description3, $StartButton, $EndButton, $Btnescape, $LogButton, $Label, $objtekst1, $objtekst2 ))

$result = $uitvoeren.form3.ShowDialog()

$uitvoeren.Form3.Close()

if ($result -eq [system.windows.forms.dialogResult]::OK) { 
    $Form2.Close()
    $form.show()
    }

} # einde overzichttaken

function startknopklikbaar {
# deze functie wordt alleen gebruikt bij functie Vensterkopieren
# en bepaald of knoppen en items van vensterkopieren zichtbaar moeten zijn

# start knop
if (($global:listbox.selecteditems.count -gt 0) -and ($lijstexamens.selecteditem -ne $null)) {
    $Btnstart.Enabled= $true
} else {
    $Btnstart.Enabled= $false
}

} # einde startknopklikbaar

function vensterkopieren { 
# taak bestanden overzetten begint hier

# variabelen

[string]$global:keuzecrebonr=""
[string]$global:keuzekerntaak=""
[string]$global:keuzeexamen=""
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

if (!(test-path -path "$digitalebestanden")) {
    $null = vraagvenster "Map bestaat niet" "De map met de te kopiren bestanden is niet gevonden!
Controleer of de volgende map aanwezig is :
- $digitalebestanden

De taak kan nu niet opgestart worden." "OK" 
    return;
}

if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}


# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# De hoofdmenu onzichtbaar maken
$form.Hide()

$Form2 = declareren_standaardvenster "Bestanden klaarzetten in de studentmappen" 920 650;

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "RPC-nummers"
$Description2.AutoSize            = $false
$Description2.width               = 150
$Description2.height              = 20
$Description2.location            = New-Object System.Drawing.Point(20,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Locatie"
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 42
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.location            = New-Object System.Drawing.Point(550,40)
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Crebonummer"
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(550,80)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Kerntaak"
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(550,120)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description8                     = New-Object system.Windows.Forms.Label
$Description8.text                = "Examen"
$Description8.AutoSize            = $false
$Description8.width               = 400
$Description8.height              = 42
$Description8.Font                = 'Microsoft Sans Serif,11'
$Description8.location            = New-Object System.Drawing.Point(550,160)
$Description8.ForeColor = [System.Drawing.Color]::Blue

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Inhoud van geselecteerde examenmap :"
$Description6.AutoSize            = $false
$Description6.width               = 330
$Description6.height              = 42
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.location            = New-Object System.Drawing.Point(200,210)
$Description6.ForeColor  = [System.Drawing.Color]::Blue

$Description7                     = New-Object system.Windows.Forms.Label
$Description7.text                = "Inhoud van geselecteerde map in examenmap :"
$Description7.AutoSize            = $false
$Description7.width               = 400
$Description7.height              = 42
$Description7.Font                = 'Microsoft Sans Serif,11'
$Description7.location            = New-Object System.Drawing.Point(550,210)
$Description7.ForeColor = [System.Drawing.Color]::Blue
$Description7.Hide()

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,550" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "kopiren" }) 
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,550" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})

# listbox is al in het begin gedeclareerd. onderstaande waarden gelden voor deze functie.
$listBox.Location = New-Object System.Drawing.Point(10,40)
$listBox.Size = New-Object System.Drawing.Size(160,500)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.BackColor  = 'white'
$listBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de RPC-nummers waar de bestanden naar toe worden overgezet." )
})


# bij aanklikken van een rpcnr, kijken of startknop weergegeven kan worden
$listbox.add_SelectedIndexChanged(
     { startknopklikbaar;
     } )

$global:listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(200,239)
$listBox2.Size = New-Object System.Drawing.Size(330,300)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.SelectionMode = 'MultiExtended'
$listBox2.items.clear()
$listBox2.BackColor  = 'white'
$listBox2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer eventueel alleen de bestanden en mappen die je wilt overzetten. 
Klik op een map om de inhoud rechts weer te geven." )
})

# bij aanklikken van een map, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged(
     { 
     # selectie krijgt waarde van volledige pad naar gekozen map
     $selectie = "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\" + $ListBox2.SelectedItem

     # alleen als 1 item is geselecteerd EN geselecteerde een map is
     if (($listbox2.selecteditems.count -eq 1) -and ((test-path -path $selectie -pathtype container) -eq $true) ) {
          
          # zichtbaar maken
          $objtekst1.Visible = $true
          $Description7.show()
          # tekstbox inhoud geven
          $objtekst1.Text = ""   

          # weergeven inhoud in tekstbox
          # eerst de volledige inhoud van de map krijgen
          $volledigetext= Get-ChildItem -Path "$selectie"
          # dan netjes in rijen plaatsen.
          foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
               }
          startknopklikbaar;

          } else {
          # venster met inhoud map onzichtbaar maken
          $objtekst1.Visible = $false
          $Description7.Hide()
          }
    }
    )

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(550,239) 
$objtekst1.Size = New-Object System.Drawing.Size(330,285)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'
$objtekst1.Hide()

$objtekst1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Dit is de inhoud van de geselecteerde map." )
})

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Locatie"
$lijstlocaties.width               = 330
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(200,40) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie." )
})

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     startknopklikbaar;
     } ) 

$lijstcrebonrs                     = New-Object system.Windows.Forms.ComboBox
$lijstcrebonrs.text                = "Crebonummer"
$lijstcrebonrs.width               = 330
$lijstcrebonrs.autosize            = $true
$lijstcrebonrs.Location = New-Object System.Drawing.Size(200,80) 
$lijstcrebonrs.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstcrebonrs.DropDownStyle="DropDownList"
$lijstcrebonrs.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de crebonummer." )
})


# crebonummers in de lijst zetten. 
Get-ChildItem -Path $digitalebestanden -Directory -Name | ForEach-Object {[void] $lijstcrebonrs.Items.Add($_)}

# uitvoeren als selectie van crebonummer wijzigt
$lijstcrebonrs.add_SelectedIndexChanged(
     { 
     $lijstkerntaken.items.clear()
     $lijstexamens.items.clear()
     $listBox2.items.clear()
     $objtekst1.Visible = $false
     $Description7.Hide()
     $global:keuzecrebonr = $lijstcrebonrs.selecteditem

     Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr" -Directory -Name | ForEach-Object {[void] $lijstkerntaken.Items.Add($_)}

     startknopklikbaar;
     } )

$lijstkerntaken                     = New-Object system.Windows.Forms.ComboBox
$lijstkerntaken.text                = "Kerntaak"
$lijstkerntaken.width               = 330
$lijstkerntaken.autosize            = $true
$lijstkerntaken.Location = New-Object System.Drawing.Size(200,120) 
$lijstkerntaken.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstkerntaken.DropDownStyle="DropDownList"
$lijstkerntaken.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de kerntaak." )
})


# uitvoeren als selectie van kerntaken wijzigt
$lijstkerntaken.add_SelectedIndexChanged(
    {
    $lijstexamens.items.clear()
    $listBox2.items.clear()
    $objtekst1.Visible = $false
    $Description7.Hide()

    $global:keuzekerntaak = $lijstkerntaken.selecteditem

    Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr\$keuzekerntaak" -Directory -Name | ForEach-Object {[void] $lijstexamens.Items.Add($_)}

    startknopklikbaar;
    } )

$lijstexamens                     = New-Object system.Windows.Forms.ComboBox
$lijstexamens.text                = "Examen"
$lijstexamens.width               = 330
$lijstexamens.autosize            = $true
$lijstexamens.Location = New-Object System.Drawing.Size(200,160) 
$lijstexamens.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstexamens.DropDownStyle="DropDownList"
$lijstexamens.Name =  "Kies een examen"
$lijstexamens.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer het examen." )
})


# uitvoeren als selectie van examens wijzigt
$lijstexamens.add_SelectedIndexChanged(
    {
    
    $listBox2.items.clear()
    $objtekst1.Visible = $false
    $Description7.Hide()

    $global:keuzeexamen = $lijstexamens.selecteditem
    
    Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen" -Name | ForEach-Object {[void] $listbox2.Items.Add($_)}

    startknopklikbaar;
    } )

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Bestanden overzetten." 690 260 520 550 "Met de taak Bestanden overzetten worden bestanden overgezet naar de RPC-nummers.
In het linkerkolom selecteert u de RPC-nummers waar de bestanden naar toe worden overgezet.
In het midden selecteert u de locatie, crebonummer, kerntaak en examen.

Eventueel kunt u ervoor kiezen om alleen enkele bestanden of mappen over te zetten.
Hiertoe moet u in het vakje onderaan deze bestanden of mappen selecteren.

Als u op een map klikt in het vakje onderaan wordt de inhoud hiervan rechts weergegeven.

Om naar het overzicht te gaan waar u het overzetten kan starten moet u op Bevestigen klikken.
"

startknopklikbaar;

$Form2.controls.AddRange(@($listBox, $lijstcrebonrs, $lijstkerntaken, $lijstexamens, $lijstlocaties, $listBox2, $Btnstart, $Btnescape, $objtekst1, $Description2,
$Description3, $Description4, $Description5, $Description6, $Description7, $Description8, $Global:vraagtekenicoon ))

#$form2.Topmost = $true
$form2.Topmost = $false

$null = $form2.ShowDialog()
    
$form2.close();
# $form2.hide();

# De hoofdmenu zichtbaar maken
$form.show()

} # einde vensterkopieren

function vensterbackup {
# taak backuppen begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten" )) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

if (!(test-path -path "$backupmap" )) {
    $null = vraagvenster "Map bestaat niet" "De backup-map is niet gevonden!
Controleer of de volgende map aanwezig is :
- $backupmap

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$Form2 = declareren_standaardvenster "Backup van bestanden in de studentmappen" 450 680

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Locatie"
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 40
$Description3.location            = New-Object System.Drawing.Point(290,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "RPC-nummers"
$Description4.AutoSize            = $false
$Description4.width               = 800
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(290,55)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "backup" }) 
$Btnstart.Enabled= $false
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})

# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,55)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 475
$listBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de RPC-nummers waarvan de backup wordt gemaakt." )
})

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$wissennabackup = New-Object System.Windows.Forms.Checkbox 
$wissennabackup.Location = New-Object System.Drawing.Point(50,580)
$wissennabackup.Size = New-Object System.Drawing.Size(300,30)
$wissennabackup.Text = "Bestanden na de backup ook wissen"
$wissennabackup.Font = 'Microsoft Sans Serif,11'
$wissennabackup.ForeColor = [System.Drawing.Color]::green
$wissennabackup.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Geef aan of de bestanden in de studentmappen na de backup worden gewist." )
})

if (($global:init["algemeen"]["wissennabackup"]) -eq "Ja") {
    $wissennabackup.checked = $true
    } else {
    $wissennabackup.checked = $false
    }

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,15) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie." )
})

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Backup maken." 730 230 400 590 "Met de taak Backup maken wordt een backup gemaakt van de geselecteerde RPC-nummers.
Bovenaan kunt u de locatie en daaronder de RPC-nummers waarvan een backup gemaakt moet worden, selecteren.

Eventueel kunt u ervoor kiezen om na de backup de bestanden op de studentenpc's te wissen.
Hiertoe moet u een vinkje zetten voor de bijbehorende tekst onderaan.

Om naar het overzicht te gaan waar u de backup kan starten moet u op Bevestigen klikken.
"

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $wissennabackup, $Description3, $Description4, $Global:vraagtekenicoon ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
} # einde vensterbackup

function vensterwissen {
# taak wissen begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$Form2 = declareren_standaardvenster "Wissen van bestanden in de studentmappen" 480 640;

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Locatie"
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 40
$Description3.location            = New-Object System.Drawing.Point(290,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "RPC-nummers"
$Description4.AutoSize            = $false
$Description4.width               = 800
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(290,55)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue


$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "wissen" }) 
$Btnstart.Enabled= $false
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$form2.cancelbutton = $Btnescape
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})


# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,55)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 475
$listBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de RPC-nummers waarvan de backup wordt gemaakt." )
})

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,15) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie." )
})

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Wissen." 690 180 430 550 "Met de taak Wissen worden bestanden van de geselecteerde RPC-nummers verwijderd.
Bovenaan kunt u de locatie en daaronder de RPC-nummers die verwijderd moet worden, selecteren.

Om naar het overzicht te gaan waar u het verwijderen kan starten moet u op Bevestigen klikken.
"

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $Description3, $Description4, $Global:vraagtekenicoon))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdvenster zichtbaar maken
$form.show()
} # einde vensterwissen

function vensterverplaatsen {
# taak verplaatsen van bestanden begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

$keuzedoelmaplegen=$global:init["algemeen"]["maplegenvoorverplaatsen"]


# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$Form2 = declareren_standaardvenster "Verplaatsen of kopiren van bestanden naar een andere studentmap" 550 380;

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Bron"
$Description2.AutoSize            = $false
$Description2.width               = 150
$Description2.height              = 50
$Description2.location            = New-Object System.Drawing.Point(300,120)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Doel"
$Description3.AutoSize            = $false
$Description3.width               = 150
$Description3.height              = 50
$Description3.location            = New-Object System.Drawing.Point(300,170)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Locatie"
$Description5.AutoSize            = $false
$Description5.width               = 300
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(300,20)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Taak"
$Description6.AutoSize            = $false
$Description6.width               = 300
$Description6.height              = 42
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.location            = New-Object System.Drawing.Point(300,70)
$Description6.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,270" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "verplaatsen" }) 
$Btnstart.Enabled= $false
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,270" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})
$form2.cancelbutton = $Btnescape

# de selectie vd de bron
$bronselectie                     = New-Object system.Windows.Forms.ComboBox
$bronselectie.width               = 260
$bronselectie.autosize            = $true
$bronselectie.DropDownStyle       = "DropDownList"
$bronselectie.Font                = 'Microsoft Sans Serif,12'
$bronselectie.location = "20,120" 
$bronselectie.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer het rpc-nummer met de bronbestanden." )
})
$bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie

#  de selectie vd de doel rpc-nummer 
$doelselectie                     = New-Object system.Windows.Forms.ComboBox
$doelselectie.width               = 260
$doelselectie.autosize            = $true
$doelselectie.DropDownStyle       = "DropDownList"
$doelselectie.Font                = 'Microsoft Sans Serif,12'
$doelselectie.location = "20,170" 
$doelselectie.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer het rpc-nummer waar de bestanden naar toe moeten." )
})
$doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

#  de keuze vd taak
$keuzeoptie1                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie1.width               = 260
$keuzeoptie1.autosize            = $true
$keuzeoptie1.DropDownStyle       = "DropDownList"
$keuzeoptie1.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie1.location = "20,70" 
[void] $keuzeoptie1.Items.Add("Verplaatsen")
[void] $keuzeoptie1.Items.Add("Kopiren")
$keuzeoptie1.Selectedindex = 0
$keuzeoptie1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de uit te voeren taak." )
})


$doelselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $doelselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
    if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$bronselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $bronselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
     if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(20,20) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie voor de rpc-nnummers." )
})

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie
     $doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

     # selectie van bron en doel ophefen
     $doelselectie.selecteditem = $null
     $bronselectie.selecteditem = $null

     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$doelmaplegen = New-Object System.Windows.Forms.Checkbox 
$doelmaplegen.Location = New-Object System.Drawing.Point(20,220)
$doelmaplegen.Size = New-Object System.Drawing.Size(500,30)
$doelmaplegen.Text = "Doelmap legen voor het verplaatsen of kopiren."
$doelmaplegen.Font = 'Microsoft Sans Serif,12'
$doelmaplegen.ForeColor = [System.Drawing.Color]::Green
if ($keuzedoelmaplegen -eq "Ja") {
    $doelmaplegen.Checked = $true
    } else {
    $doelmaplegen.Checked = $false
    }
$doelmaplegen.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Geef aan of de doelmap geleegd moet worden voor het uitvoeren van de taak." )
})

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Verplaatsen of Kopiren." 680 280 460 290 "Met de taak Verplaatsen of Kopiren worden bestanden van de geselecteerde RPC-nummer
verplaatst of gekopierd naar een andere RPC-nummer.

Geef aan in welke RPC-nummer de bestanden staan, dit is de bron. 
Dan naar welke RPC-nummer de bestanden worden gekopierd, dat is het doel. 
Eventueel kan de locatie of taak nog worden aangepast.

Als Doelmap legen voor het verplaatsen of kopiren is aangevinkt zal de inhoud van de doelmap 
gewist worden voor het verplaatsen of kopiren.

Om naar het overzicht te gaan waar u het verplaatsen kan starten moet u op Bevestigen klikken."

$form2.controls.AddRange(@($lijstlocaties, $keuzeoptie1, $bronselectie, $doelselectie, $doelmaplegen, $Btnstart, $Btnescape, $Description2, 
$Description3, $Description4, $Description5, $Description6, $Global:vraagtekenicoon ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
} # einde vensterverplaatsen

function programmaafsluiten {
# een venster met de vraag of je zeker het programma wilt sluiten

$result = vraagvenster "Afsluiten?" "
          U gaat het programma sluiten. 

          Weet u het zeker?" "Ja" "Nee"

# if ($result -eq 'Yes') {

if ($result -eq 'Ok') {
    # programma sluiten
    $form.dispose()
}

} # einde programmaafsluiten

function vensterlogbestand {
# de taak logbestand bekijken begint hier

# controle of er logbestanden zijn
if (!(Test-Path -Path "$logmap\*.txt")) {
    $null = vraagvenster "Geen logbestanden" "
    
Er zijn geen logbestanden om te weergeven."
    return;
    }

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$Form2 = declareren_standaardvenster "Logbestanden bekijken" 1060 670

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Filter op jaar"
$Description2.AutoSize            = $false
$Description2.width               = 100
$Description2.height              = 42
$Description2.location            = New-Object System.Drawing.Point(20,18)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "en op maand"
$Description3.AutoSize            = $false
$Description3.width               = 100
$Description3.height              = 42
$Description3.location            = New-Object System.Drawing.Point(210,18)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Logbestanden"
$Description4.AutoSize            = $false
$Description4.width               = 120
$Description4.height              = 20
$Description4.location            = New-Object System.Drawing.Point(20,65)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Inhoud van geselecteerde logbestand"
$Description5.AutoSize            = $false
$Description5.width               = 280
$Description5.height              = 20
$Description5.location            = New-Object System.Drawing.Point(160,65)
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.ForeColor = [System.Drawing.Color]::Blue

$filterjaar                     = New-Object system.Windows.Forms.ComboBox
$filterjaar.width               = 70
$filterjaar.autosize            = $true
$filterjaar.DropDownStyle       = "DropDownList"
$filterjaar.Font                = 'Microsoft Sans Serif,12'
$filterjaar.location = "120,15" 
# vullen met jaren
for ($i=2022; $i -le 2040; $i++) {
    [void] $filterjaar.Items.Add($i)
}
$filterjaar.add_SelectedIndexChanged({
    $filtermaand.Enabled = $true
    $filtermaand.selecteditem = $null
    $listbox2.Items.clear()

    Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
        $datumlog = bepaaldatumuitlognaam "$_"

        if ($datumlog.Contains($filterjaar.selecteditem)) { 
            [void] $listbox2.Items.Add($datumlog)
        }
    }
    if ($listbox2.Items.count -gt 0) { $listBox2.SelectedIndex = 0 }
        else { $objtekst1.Text = "" }
})
$filterjaar.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Toon alleen de logbestanden van de geselecteerde jaar." )
})

$filtermaand                     = New-Object system.Windows.Forms.ComboBox
$filtermaand.width               = 50
$filtermaand.autosize            = $true
$filtermaand.DropDownStyle       = "DropDownList"
$filtermaand.Font                = 'Microsoft Sans Serif,12'
$filtermaand.location = "320,15" 
$filtermaand.Enabled = $false
# vullen met maanden
for ($i=01; $i -le 12; $i++) {
    if ($i -lt 10) {
        [void] $filtermaand.Items.Add("0$i")
        } else {
        [void] $filtermaand.Items.Add("$i")
        }
}
$filtermaand.add_SelectedIndexChanged({
    $listbox2.Items.clear()

    Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
        $datumlog = bepaaldatumuitlognaam "$_"
        $filter = -join ($filterjaar.selecteditem,"-",$filtermaand.selecteditem)
        if ($datumlog.Contains($filter)) { 
            [void] $listbox2.Items.Add($datumlog)
        }
    }
    if ($listbox2.Items.count -gt 0) { $listBox2.SelectedIndex = 0 }
        else { $objtekst1.Text = "" }
})
$filtermaand.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Toon alleen de logbestanden van de geselecteerde maand." )
})

$filterwissen = New-object System.Windows.Forms.Button 
$filterwissen.text= "Filters wissen"
$filterwissen.location = "400,15" 
$filterwissen.size = "150,30"  
$filterwissen.BackColor = 'blue'
$filterwissen.ForeColor = 'white'
$filterwissen.add_click({
    
    $filtermaand.selecteditem = $null
    $filterjaar.selecteditem = $null
    $filtermaand.Enabled = $false

    $listbox2.Items.clear()
    Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)        
    }
    # eerste logbestand is geselecteerd.
    $listBox2.SelectedIndex = 0
})
$filterwissen.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Wis alle filters en laat alle logbestanden weer zien." )
})

$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,590" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'red'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Buttenok.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster." )
})

$listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(10,90)
$listBox2.Size = New-Object System.Drawing.Size(120,20)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.Height = 495
$listBox2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de datum van het logbestand die u wilt zien." )
})

# bij aanklikken van een datum, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged( {
    $objtekst1.Text = ""
    # datum omzetten naar bestandsnaam
    $gekozendatum = bepaallognaam $ListBox2.SelectedItem
    # inhoud bestand inlezen
    $volledigetext = Get-Content -Path "$gekozendatum"
    # dan netjes in rijen plaatsen.
    foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + "$item" + "`r`n"
               }
    } )

# inhoud van logmap weergeven met listbox2
Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)
    }

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(150,90) 
$objtekst1.Size = New-Object System.Drawing.Size(880,484)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'
$objtekst1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Inhoud van het geselecteerde logbestand." )
})

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over het venster Logbestanden bekijken." 680 180 500 590 "Als u links de datum van het logbestand dat je wilt bekijken selecteert, dan wordt rechts 
de inhoud weergegeven.

U kunt om sneller een logbestand te vinden, bovenaan filteren op jaar en maand.
Door om de knop Filters wissen te klikken ziet u weer alle logbestanden." 

$Form2.Controls.AddRange(@($Description2, $Description3, $Description4, $Description5, $filterjaar, $filtermaand, $filterwissen, $Buttenok, $listbox2, $objtekst1, $Global:vraagtekenicoon ))

# eerste logbestand is geselecteerd.
$listBox2.SelectedIndex = 0

$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()
} # einde vensterlogbestand

function updatevoorbereiden ($opgestart) {
<# de taak updaten begint hier

 variabelen voor deze functie
 $opgestart geeft aan hoe dit is aangeroepen: auto of keuzemenu
#>

<# $huidigeversie wordt alleen in deze functie gebruikt en is er om te verduidelijken dat dit de huidge versie is en
   om niet overal "global:" voor te zetten. $versie is namelijk een global variabele.
#>
$huidigeversie = $global:versie

# updaten naar een versie. "uptodate" betekent geen update nodig, 
$updateto="uptodate"
# of deze versie verouderd is
$deprecated = $false
# pad naar updateinfo op lokale pc
$updateinfobestand = -join ("$startmap","\","$global:updateinfo")
# bepalen downloadbestand
$downloadbestand = -join ("$updatewebsite","/updates/","$global:updateinfo")
# $autoupdate is afhankelijk van instelling in initialisatiebestand
if ($global:init["algemeen"]["autoupdate"] -eq "Ja") {
    $autoupdate = $true 
    } else {
    $autoupdate = $false
    }

<# controleren of een update is uitgevoerd en zo ja verwijderen bestand
   zo kan ga je niet na een update, opnieuw updaten
   als je bent opgestart via hoofdvenster dan niet afsluiten
#>
if (test-path -path $updateinfobestand -pathtype leaf) { 
    Remove-Item "$updateinfobestand" 
    if ($opgestart -eq "begin")  { return }
    }

# downloaden updateinfobestand van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$updateinfobestand" -ErrorAction Stop
    }
catch {
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Bestand met update-informatie niet kunnen downloaden!  
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Bestand met update-informatie niet kunnen downloaden! "
        Start-Sleep -s 3
        }
    return
    }
      
# inlezen updateinfobestand en controleren op een update ...

# inlezen ini-bestand naar object
$global:updateini = Get-IniContent $updateinfobestand

# controleren of versie verouderd is
if ("$huidigeversie" -le $updateini["deprecated"]["old"]) { $deprecated = $true }

# controleren op revisie en anders op laatste versie 
if ($updateini["revision"].Contains($huidigeversie) ) {
    $updateto = $updateini["revision"]["$huidigeversie"]
    } else {
    
    if ("$huidigeversie" -lt $updateini["program"]["latest"]) {
        $updateto = $updateini["program"]["latest"]
        }
} 
# einde controles. er is bepaald of er een update is.

# programma is up to date?
if ($updateto -eq "uptodate") {

    Remove-Item "$updateinfobestand" 
    if ($opgestart -eq "keuzemenu")  { 
        $null = vraagvenster "Geen update nodig" "
        Een update is niet nodig.
        Het programma heeft de laatste versie." "OK"
        }
    return
}

# Er is een update beschikbaar

# afhankelijk van opstartkeuze en autoupdate, melding geven of doorgaan.
if ($opgestart -eq "keuzemenu") {

    $result = vraagvenster "Er is een update beschikbaar" "
Er is een nieuwe versie van dit programma beschikbaar.

Updaten naar versie $updateto ?" "Ja" "Nee"
    if ($result -eq "Cancel") { 
        Remove-Item "$updateinfobestand" 
        return 
        }
    } else {

    if (! ($autoupdate) ) { 
        Remove-Item "$updateinfobestand" 

        if ($global:init["algemeen"]["updatenotificatie"] -eq "Ja" ) {

        if ($deprecated) {
            $messageboxtekst = "Er is een nieuwe versie van dit programma beschikbaar.

Kies in het hoofdvenster 'Controleren op een update' 
of zet deze melding bij 'Instellingen' voortaan uit.
U wordt echter aangeraden deze te installeren omdat de huidige versie verouderd is."
            } else {
            $messageboxtekst = "Er is een nieuwe versie van dit programma beschikbaar. 

Kies in het hoofdvenster 'Programma updaten'
of zet deze melding bij 'Instellingen' voortaan uit."
            }
        $null = vraagvenster "Er is een update beschikbaar" "$messageboxtekst" "Ok"

        } # einde if $updateini["algemeen"]["updatenotificatie"]

        return
        } # einde if (! ($autoupdate) )
    } # einde if opgestart ... else

# variabelen die nodig zijn voor het downloaden. 
# bestand met update die gedownload wordt
$zip_download = "beherenbestanden_$updateto.zip"
# pad naar bestand met update op de website
$downloadbestand = bepaalversiemap "$updateto"
# pad naar bestand met update op de website, samenvoegen met update die gedownload wordt
$downloadbestand = -join ("$downloadbestand","/","$zip_download")
# pad naar bestand met update op lokale pc
$zip_download = -join ("$startmap","\","$zip_download")

# downloaden zip_download van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$zip_download" -ErrorAction Stop
    }
catch {
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Bestand met update niet kunnen downloaden! 

Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Bestand met update niet kunnen downloaden! "
        Start-Sleep -s 3
        }
    return
    }

# tempmap aanmaken. als deze al bestaat wordt geen melding gegeven.
# vervolgens leeg maken
$tempmap = "$startmap\temp"

mkdir $tempmap -ErrorAction SilentlyContinue 1>$null
Remove-Item "$tempmap\*" -Recurse -Force 

# uitpakken van programma naar tempmap. alleen de updater is nu nodig.
Expand-Archive -Path "$zip_download" -DestinationPath "$tempmap" -Force

# zipbestand na het uitpakken direct verwijderen
Remove-Item "$zip_download"

# updater wordt nu geupdated

# kopiren updater en foutmeldingen opvangen
$error.clear()
try {
    Copy-Item -path "$tempmap\$updater" -destination "$startmap" -ErrorAction Stop
    }
catch {
    
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Fout tijdens het updaten.  Het bestand " + $updater + " is niet gepdatet. 
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Fout tijdens het updaten. Het bestand " + $updater + " is niet gepdatet."
        Start-Sleep -s 3
        }
    return
    }


# buttons sluiten. Anders krijg je een foutmelding bij script updater bij het kopieren van de map "png".
# de png-bestanden blijven namelijk nog in gebruik door powershell en de melding "icoon-backup.png is in use" verschijnt.
$Button1.Image.Dispose()
$Button2.Image.Dispose()
$Button3.Image.Dispose()
$Button4.Image.Dispose()
$Button5.Image.Dispose()
$Button6.Image.Dispose()
$Button7.Image.Dispose()
$Button8.Image.Dispose()
$Button9.Image.Dispose()
$Button10.Image.Dispose()
$picturequestion.image.dispose()
$gifBox.Image.dispose()
# $Button11.Image.Dispose()

# vensters sluiten

$form.Dispose()
$Form_opstart.dispose()

# opstarten updater
& "$PSScriptRoot\$updater"

# beindigen van programma als updaten in het begin is opgestart
if ($opgestart -eq "begin") {
    exit;
    } 

} # einde updatevoorbereiden

function vensterinstellingen {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# venster declareren
$Form2 = declareren_standaardvenster "Instellingen wijzigen" 600 520

$keuzeoptie1                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie1.width               = 80
$keuzeoptie1.autosize            = $true
$keuzeoptie1.DropDownStyle       = "DropDownList"
$keuzeoptie1.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie1.location = "450,20" 

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    # locatiecode toevoegen
    [void] $keuzeoptie1.Items.Add("$_")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $keuzeoptie1.Selectedindex = $teller }
    $teller++
    }

$keuzeoptie2                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie2.width               = 80
$keuzeoptie2.autosize            = $true
$keuzeoptie2.DropDownStyle       = "DropDownList"
$keuzeoptie2.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie2.location = "450,60" 
[void] $keuzeoptie2.Items.Add("Ja")
[void] $keuzeoptie2.Items.Add("Nee")
if ($global:init["algemeen"]["wissennabackup"] -eq "Ja") {
    $keuzeoptie2.Selectedindex = 0
    } else {
    $keuzeoptie2.Selectedindex = 1
    }

$keuzeoptie3                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie3.width               = 80
$keuzeoptie3.autosize            = $true
$keuzeoptie3.DropDownStyle       = "DropDownList"
$keuzeoptie3.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie3.location = "450,100" 
[void] $keuzeoptie3.Items.Add("Ja")
[void] $keuzeoptie3.Items.Add("Nee")
if ($global:init["algemeen"]["maplegenvoorverplaatsen"] -eq "Ja") {
    $keuzeoptie3.Selectedindex = 0
    } else {
    $keuzeoptie3.Selectedindex = 1
    }

$keuzeoptie4                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie4.width               = 80
$keuzeoptie4.autosize            = $true
$keuzeoptie4.DropDownStyle       = "DropDownList"
$keuzeoptie4.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie4.location = "450,140" 
[void] $keuzeoptie4.Items.Add("Ja")
[void] $keuzeoptie4.Items.Add("Nee")
if ($global:init["algemeen"]["autoupdate"] -eq "Ja") {
    $keuzeoptie4.Selectedindex = 0
    } else {
    $keuzeoptie4.Selectedindex = 1
    }
$keuzeoptie4.add_SelectedIndexChanged({
    if ($keuzeoptie4.Selectedindex -eq 0) {
    $keuzeoptie5.enabled = $false
    $Description5.ForeColor = [System.Drawing.Color]::gray
    }
        else {
    $keuzeoptie5.enabled = $true
    $Description5.ForeColor = [System.Drawing.Color]::Blue
    }
})

$keuzeoptie5                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie5.width               = 80
$keuzeoptie5.autosize            = $true
$keuzeoptie5.DropDownStyle       = "DropDownList"
$keuzeoptie5.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie5.location = "450,180" 
[void] $keuzeoptie5.Items.Add("Ja")
[void] $keuzeoptie5.Items.Add("Nee")
if ($global:init["algemeen"]["updatenotificatie"] -eq "Ja") {
    $keuzeoptie5.Selectedindex = 0
    } else {
    $keuzeoptie5.Selectedindex = 1
    }
if ($global:init["algemeen"]["autoupdate"] -eq "Ja") {
    $keuzeoptie5.enabled = $false
    } 

$keuzeoptie6                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie6.width               = 80
$keuzeoptie6.autosize            = $true
$keuzeoptie6.DropDownStyle       = "DropDownList"
$keuzeoptie6.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie6.location = "450,220" 
[void] $keuzeoptie6.Items.Add("Ja")
[void] $keuzeoptie6.Items.Add("Nee")
if ($global:init["opschonen"]["opschonenlogs"] -eq "Ja") {
    $keuzeoptie6.Selectedindex = 0
    } else {
    $keuzeoptie6.Selectedindex = 1
    }

$keuzeoptie7 = New-Object System.Windows.Forms.TextBox 
$keuzeoptie7.Location = New-Object System.Drawing.Size(450,260) 
$keuzeoptie7.Size = New-Object System.Drawing.Size(80,60)
$keuzeoptie7.MaxLength = 4
$keuzeoptie7.Font = 'Microsoft Sans Serif,11'
$keuzeoptie7.Text=$Global:init["opschonen"]["dagenbewarenlogs"]
$keuzeoptie7.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})

$keuzeoptie8 = New-Object System.Windows.Forms.TextBox 
$keuzeoptie8.Location = New-Object System.Drawing.Size(450,300) 
$keuzeoptie8.Size = New-Object System.Drawing.Size(80,60)
$keuzeoptie8.MaxLength = 4
$keuzeoptie8.Font = 'Microsoft Sans Serif,11'
$keuzeoptie8.Text=$Global:init["opschonen"]["dagenbewarenbackup"]
$keuzeoptie8.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Standaard locatie"
$Description1.AutoSize            = $false
$Description1.width               = 400
$Description1.height              = 30
$Description1.location            = New-Object System.Drawing.Point(40,20)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::Blue
$Description1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Met de standaard locatie wordt bepaald welke rpc-nummers geselecteerd kunnen worden." )
})

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Studentmappen wissen na uitvoeren van een backup"
$Description2.AutoSize            = $false
$Description2.width               = 400
$Description2.height              = 30
$Description2.location            = New-Object System.Drawing.Point(40,60)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue
$Description2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of standaard de optie om de studentmappen te wissen is geselecteerd bij het uitvoeren van een backup." )
})

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Studentmap wissen voor het verplaatsen van bestanden"
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(40,100)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue
$Description3.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of standaard de optie om de studentmap te wissen is geselecteerd bij het verplaatsen van bestanden." )
})

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Automatisch updaten bij de start van het programma"
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 30
$Description4.location            = New-Object System.Drawing.Point(40,140)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue
$Description4.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of het programma automatisch wordt gepdatet." )
})

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Melding geven wanneer een update beschikbaar is"
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 30
$Description5.location            = New-Object System.Drawing.Point(40,180)
$Description5.Font                = 'Microsoft Sans Serif,11'
# kleur bepalen afhankelijk van of deze enabled is of niet
if ($keuzeoptie4.Selectedindex -eq 0) {
    $Description5.ForeColor = [System.Drawing.Color]::gray
    }
        else {
    $Description5.ForeColor = [System.Drawing.Color]::Blue
    }
$Description5.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Als automatisch updaten niet wordt uitgevoerd, wordt hier bepaald of er wel een melding komt." )
})

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Automatisch verwijderen oude logbestanden bij de start van het programma"
$Description6.AutoSize            = $false
$Description6.width               = 400
$Description6.height              = 40
$Description6.location            = New-Object System.Drawing.Point(40,220)
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.ForeColor = [System.Drawing.Color]::Blue
$Description6.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of bij het opstarten logbestanden verwijderd worden. Hierbij wordt gebruikt gemaakt van de instelling hieronder." )
})

$Description7                     = New-Object system.Windows.Forms.Label
$Description7.text                = "Standaard dagen voor het verwijderen van logbestanden van het programma"
$Description7.AutoSize            = $false
$Description7.width               = 400
$Description7.height              = 40
$Description7.location            = New-Object System.Drawing.Point(40,260)
$Description7.Font                = 'Microsoft Sans Serif,11'
$Description7.ForeColor = [System.Drawing.Color]::Blue
$Description7.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal tot hoeveel dagen de logbestanden bewaard blijven bij het verwijderen van oude logbestanden." )
})

$Description8                     = New-Object system.Windows.Forms.Label
$Description8.text                = "Standaard dagen voor het verwijderen van backups van de studentmappen"
$Description8.AutoSize            = $false
$Description8.width               = 400
$Description8.height              = 40
$Description8.location            = New-Object System.Drawing.Point(40,300)
$Description8.Font                = 'Microsoft Sans Serif,11'
$Description8.ForeColor = [System.Drawing.Color]::Blue
$Description8.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal tot hoeveel dagen de backups bewaard blijven bij het verwijderen van oude backups." )
})

$Btnstandaard = New-object System.Windows.Forms.Button 
$Btnstandaard.text= "Herstel de standaardinstellingen"
$Btnstandaard.location = "50,360" 
$Btnstandaard.size = "250,30"  
$Btnstandaard.BackColor = 'blue'
$Btnstandaard.ForeColor = 'white'
$Btnstandaard.add_click({
    # inlezen ini-bestand naar tijdelijke object
    $temp_init = standaardinstellingen

    # alle opties krijgen hun standaard waarde. Er wordt nog niets bewaard!
    $keuzeoptie1.SelectedItem=$temp_init["algemeen"]["locatiekeuze"]
    $keuzeoptie2.SelectedItem=$temp_init["algemeen"]["wissennabackup"]
    $keuzeoptie3.SelectedItem=$temp_init["algemeen"]["maplegenvoorverplaatsen"]
    $keuzeoptie4.SelectedItem=$temp_init["algemeen"]["autoupdate"]
    $keuzeoptie5.SelectedItem=$temp_init["algemeen"]["updatenotificatie"]

    $keuzeoptie6.SelectedItem=$temp_init["opschonen"]["opschonenlogs"]
    $keuzeoptie7.Text=$temp_init["opschonen"]["dagenbewarenlogs"]
    $keuzeoptie8.Text=$temp_init["opschonen"]["dagenbewarenbackup"]    
}) # einde Btnstandaard.add_click
$Btnstandaard.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Zet alle instellingen terug naar de standaard waarden." )
})

$Btnaccept = New-object System.Windows.Forms.Button 
$Btnaccept.text= "Bewaren"
$Btnaccept.location = "50,410" 
$Btnaccept.size = "150,30"  
$Btnaccept.BackColor = 'green'
$Btnaccept.ForeColor = 'white'
$Btnaccept.DialogResult = [System.Windows.Forms.DialogResult]::yes
$Btnaccept.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Sla de wijzingen op en ga terug naar het hoofdvenster." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,410" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster zonder de wijzigingen op te slaan." )
})


# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over het venster Instellingen." 680 240 540 410 "Wijzig hier de standaard instellingen van het programma.

U krijgt extra informatie over een instelling als de muiscursor op een tekst staat.
U kunt alle instellingen herstellen naar de standaardwaarde door op de knop 
Herstel de standaardinstellingen te klikken.

Als u de instellingen wilt bewaren klikt u op Bewaren.
Als u terug wilt zonder de instellingen te bewaren klikt u op Annuleren.
" 

$Form2.Controls.AddRange(@($keuzeoptie1, $keuzeoptie2, $keuzeoptie3, $keuzeoptie4, $keuzeoptie5, $keuzeoptie6, $keuzeoptie7, $keuzeoptie8,
$description1, $description2, $description3, $description4, $description5, $description6, $description7, $description8, $Btnstandaard, 
$Btnaccept, $Btnescape, $Global:vraagtekenicoon ))

# openen venster
$result = $form2.ShowDialog()

# bewaren van instellingen
if ($result -eq [system.windows.forms.dialogResult]::yes) { 

    # keuzes worden ingesteld
    $global:init["algemeen"]["locatiekeuze"]=$keuzeoptie1.Selecteditem
    $global:init["algemeen"]["wissennabackup"]=$keuzeoptie2.Selecteditem
    $global:init["algemeen"]["maplegenvoorverplaatsen"]=$keuzeoptie3.Selecteditem
    $global:init["algemeen"]["autoupdate"]=$keuzeoptie4.Selecteditem
    $global:init["algemeen"]["updatenotificatie"]=$keuzeoptie5.Selecteditem
    $global:init["opschonen"]["opschonenlogs"]=$keuzeoptie6.Selecteditem
    if (!($keuzeoptie7.Text -eq "" )) {
        # eventueel de nullen ervoor weghalen
        [int32]$getal1=$keuzeoptie7.Text
        $global:init["opschonen"]["dagenbewarenlogs"]=$getal1
    }
    if (!($keuzeoptie8.Text -eq "" )) {
        # eventueel de nullen ervoor weghalen
        [int32]$getal1=$keuzeoptie8.Text
        $global:init["opschonen"]["dagenbewarenbackup"]=$getal1
    }
    # bestand met nieuwe variabele bewaren
    $global:init | ConvertTo-Json -depth 1 | Set-Content -Path $global:initbestand

} # einde bewaren van instellingen

# De hoofdmenu zichtbaar maken
$form.show()

} # einde vensterinstellingen

function uitvoerenopschonen {

# controle of geldige invoer is gegeven
if (($uitvoerenbackups.Checked) -and ($objTextBox1.Text -eq "" )) {
    $null = vraagvenster "Geen geldige getal ingevuld" "Vul een geldige getal in voor het aantal dagen verwijderen backups." "OK"
    return;
}

if (($uitvoerenlogbestanden.Checked) -and ($objTextBox2.Text -eq "" )) {
    $null = vraagvenster "Geen geldige getal ingevuld" "Vul een geldige getal in voor het aantal dagen verwijderen logbestanden" "OK"
    return;
}

# mappen controleren of deze bestaan
# eerst de backupmap
if ($uitvoerenbackups.Checked) {
    if (!(test-path -path "$backupmap")) {
    $null = vraagvenster "Map bestaat niet" "De backup-map is niet gevonden!
Controleer of de volgende map aanwezig is :
- $backupmap

De taak kan nu niet opgestart worden." "OK"
    return;
    }
}
# dan de logmap
if ($uitvoerenlogbestanden.Checked) {
    if (!(test-path -path "$logmap")) {
    $null = vraagvenster "Map bestaat niet" "De log-map is niet gevonden!
Controleer of de volgende map aanwezig is :
- $logmap

De taak kan nu niet opgestart worden." "OK"
    return;
    }
}

# ingevoerde getallen uit de invulboxen halen en eventueel de nullen ervoor eruit halen. dit laatste is een controle.
# getal1 is voor de backups en getal2 voor de logbestanden
[int32]$getal1=$objTextBox1.Text
[int32]$getal2=$objTextBox2.Text

# aantal backups en logbestanden die worden verwijderd tellen
$tellerlogs=0
$tellerbackups=0

if ($uitvoerenbackups.Checked) {
    # deze get-childitem is dezelfde als onder bij het daadwerkelijk uitvoeren
    Get-ChildItem -Path "$backupmap" | Where-Object {($_.psiscontainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal1))} | foreach-object {
        $tellerbackups++
        }
    }
if ($uitvoerenlogbestanden.Checked) {
    Get-ChildItem -Path "$logmap" | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        $tellerlogs++
        }
    }

# aantallen zijn geteld en als beiden nul zijn kan je niet verder
if (( $tellerlogs -eq 0) -and ($tellerbackups -eq 0)) {
    $null = vraagvenster 'Geen bestanden om te verwijderen' "
Met de huidige instellingen worden er geen backups of logbestanden verwijderd!
Maak opnieuw een keuze als dit niet klopt of Annuleer het opschonen als dit wel klopt." 'Ok'
    return;
}
 
# aantallen bij elkaar optellen voor de progressbar
$ProgressBar.maximum = $tellerlogs + $tellerbackups

# bepalen tekst om weer te geven in vraag om opschonen
if (($uitvoerenbackups.Checked) -and ($uitvoerenlogbestanden.Checked)) {
    $vraagopschonen="De volgende keuzes zijn gemaakt:

Er worden $tellerbackups Backups ouder dan $getal1 dagen en
$tellerlogs Logbestanden ouder dan $getal2 dagen verwijderd.

Klik op Doorgaan als dit juist is."
    } elseif (($uitvoerenbackups.Checked) -and (!($uitvoerenlogbestanden.Checked)) ) {
    $vraagopschonen="De volgende keuze is gemaakt:

Er worden $tellerbackups Backups ouder dan $getal1 dagen verwijderd.

Klik op Doorgaan als dit juist is."
    } else {
    $vraagopschonen="De volgende keuze is gemaakt:

Er worden $tellerlogs Logbestanden ouder dan $getal2 dagen verwijderd.

Klik op Doorgaan als dit juist is."
    }

$result=vraagvenster "Overzicht van de gemaakte keuzes" $vraagopschonen "Doorgaan" "Annuleren"

if ( $result -eq "Cancel") { return }

$vraagopschonen="LET OP : Als u nu op Opschonen klikt worden de bestanden definitief verwijderd!

Dit kan niet worden teruggedraaid.

Klik op Annuleren als u terug wilt.
"
$result=vraagvenster "Starten met opschonen?" $vraagopschonen "Opschonen" "Annuleren"

if ( $result -eq "Cancel") { return }

# start proces verwijderen

# objecten niet meer klikbaar maken.
$uitvoerenbackups.enabled = $false
$uitvoerenlogbestanden.enabled = $false
$objTextBox1.enabled = $false
$objTextBox2.enabled = $false

# koppen onzichtbaar maken
$btnaccept.hide()
$btnescape.hide()

# tekst weergeven dat de taak gestart is
$uitleg_opschonen.ForeColor = 'red'
$uitleg_opschonen.Text = "Opschonen wordt uitgevoerd ..."

# progressbar zichtbaar maken
$progressBar.Visible=$true

# datum bepalen
$datumvandaag = bepaaldatum;

# logbestandsnaam definiren en volledige pad naar bestand invoeren
# $logbestand = -join ("$logmap","\log_","$datumvandaag",".txt")
$logbestand = bepaallognaam "$datumvandaag"

# starttijd van loggen naar variabele
$logtijd = get-date -Format "HH:mm:ss"

#foutmelding voor logbestand
$foutmelding_log="[ FOUT ] "
$foutmelding = $false

# in logbestand schrijven
"Het opschonen van bestanden is uitgevoerd." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append

# verwijderen oude backups
if ($uitvoerenbackups.Checked) {
    # in logbestand info schrijven
    "De volgende $tellerbackups backupmappen ouder dan $getal1 dagen verwijderen : " | out-file $logbestand -Append

    # bepaal de lijst met mappen die verwijderd worden
    Get-ChildItem -Path "$backupmap" | Where-Object {($_.psiscontainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal1))} | foreach-object {
        # map om te verwijderen
        $todelete = $_
        # in logbestand schrijven
        " - $todelete " | out-file $logbestand -Append
        # stap nemen in progressbar
        $ProgressBar.PerformStep()
        #verwijderen map en opvangen foutmelding met try- catch methode
        $error.clear()
        try {
            Remove-Item "$backupmap\$todelete" -recurse -force -ErrorAction Stop
            }
        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_ | out-file $logbestand -Append
            $foutmelding = $true
              } # einde try catch
    } # einde get-childitem
    } # einde if $uitvoerenbackups.Checked

# verwijderen oude logs
if ($uitvoerenlogbestanden.Checked) {
    # in logbestand info schrijven
    "De volgende $tellerlogs logbestanden ouder dan $getal2 dagen verwijderen : " | out-file $logbestand -Append

    # bepaal de lijst met mappen die verwijderd worden
    Get-ChildItem -Path "$logmap" | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        # map om te verwijderen
        $todelete = $_
        # in logbestand schrijven
        " - $todelete " | out-file $logbestand -Append
        # stap nemen in progressbar
        $ProgressBar.PerformStep()
        Start-Sleep -s 1
        #verwijderen map en opvangen foutmelding met try- catch methode
        $error.clear()
        try {
            Remove-Item "$logmap\$todelete" -force -ErrorAction Stop 
            }
        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_ | out-file $logbestand -Append
            $foutmelding = $true
              } # einde try catch
    } # einde get-childitem

    } # einde if $uitvoerenlogbestanden.Checked

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
$logtijd = get-date -Format "HH:mm:ss"

"" | out-file $logbestand -Append
"Eindtijd  : $logtijd" | out-file $logbestand -Append
" -------------------------------------------------------------------------" | out-file $logbestand -Append
"" | out-file $logbestand -Append


# de log-knop zichtbaar maken en start-knop onzichtbaar
$LogButton.show()
$Btnescape.text= "Terug"
$Btnescape.BackColor = 'blue'
$btnescape.show()

# aangeven dat taken zijn uitgevoerd 
if ($foutmelding) { $uitleg_opschonen.Text = "Het opschonen is niet correct uitgevoerd. Bekijk de foutmeldingen in het logbestand."
    } else { $uitleg_opschonen.Text = "Opschonen is uitgevoerd." }
} # einde uitvoerenopschonen

function vensteropschonen {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$Form2 = declareren_standaardvenster "Verwijder oude backups van de studentmappen en/of oude logbestanden" 650 400

$uitleg_opschonen                     = New-Object system.Windows.Forms.Label
$uitleg_opschonen.text                = "Opties :"
$uitleg_opschonen.AutoSize            = $false
$uitleg_opschonen.width               = 580
$uitleg_opschonen.height              = 20
$uitleg_opschonen.location            = New-Object System.Drawing.Point(20,15)
$uitleg_opschonen.Font                = 'Microsoft Sans Serif,12'
$uitleg_opschonen.ForeColor = [System.Drawing.Color]::Blue

$uitvoerenbackups = New-Object System.Windows.Forms.Checkbox 
$uitvoerenbackups.Location = New-Object System.Drawing.Point(20,40)
$uitvoerenbackups.Size = New-Object System.Drawing.Size(500,30)
$uitvoerenbackups.Text = "Verwijder backups van de studentmappen."
$uitvoerenbackups.Font = 'Microsoft Sans Serif,12'
$uitvoerenbackups.ForeColor = [System.Drawing.Color]::Green
$uitvoerenbackups.add_click( {
     if ($uitvoerenbackups.Checked) {
        $Description1.Show()
        $Description3.Show()
        $objTextBox1.Show()
        $Btnaccept.Enabled=$true
        } else {
        $Description1.hide()
        $Description3.hide()
        $objTextBox1.Hide()
        if (!($uitvoerenlogbestanden.Checked)) { $Btnaccept.Enabled=$false }
        }
     } )
$uitvoerenbackups.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Geef aan of oude backups van de studentmappen verwijderd moeten worden." )
})

$uitvoerenlogbestanden = New-Object System.Windows.Forms.Checkbox 
$uitvoerenlogbestanden.Location = New-Object System.Drawing.Point(20,90)
$uitvoerenlogbestanden.Size = New-Object System.Drawing.Size(500,30)
$uitvoerenlogbestanden.Text = "Verwijder logbestanden van het programma."
$uitvoerenlogbestanden.Font = 'Microsoft Sans Serif,12'
$uitvoerenlogbestanden.ForeColor = [System.Drawing.Color]::Green
$uitvoerenlogbestanden.add_click( {
     if ($uitvoerenlogbestanden.Checked) {
        $Description2.Show()
        $Description4.Show()
        $objTextBox2.Show()
        $Btnaccept.Enabled=$true
        } else {
        $Description2.hide()
        $Description4.hide()
        $objTextBox2.Hide()
        if (!($uitvoerenbackups.Checked)) { $Btnaccept.Enabled=$false }
        }
     } )
$uitvoerenlogbestanden.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Geef aan of oude logbestanden verwijderd moeten worden." )
})

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Backups van de studentmappen die ouder zijn dan"
$Description1.AutoSize            = $false
$Description1.width               = 360
$Description1.height              = 40
$Description1.location            = New-Object System.Drawing.Point(20,142)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::blue
$Description1.hide()
$Description1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Wijzigen eventueel tot hoeveel dagen oud de backups bewaard blijven." )
})

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Logbestanden van het programma die ouder zijn dan"
$Description2.AutoSize            = $false
$Description2.width               = 360
$Description2.height              = 40
$Description2.location            = New-Object System.Drawing.Point(20,192)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::blue
$Description2.hide()
$Description2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Wijzigen eventueel tot hoeveel dagen oud de logbestanden bewaard blijven." )
})

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "dagen worden verwijderd."
$Description3.AutoSize            = $false
$Description3.width               = 200
$Description3.height              = 40
$Description3.location            = New-Object System.Drawing.Point(440,142)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::blue
$Description3.hide()

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "dagen worden verwijderd."
$Description4.AutoSize            = $false
$Description4.width               = 200
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(440,192)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::blue
$Description4.hide()

$objTextBox1 = New-Object System.Windows.Forms.TextBox 
$objTextBox1.Location = New-Object System.Drawing.Size(380,140) 
$objTextBox1.Size = New-Object System.Drawing.Size(55,50)
$objTextBox1.MaxLength = 4
$objTextBox1.Font = 'Microsoft Sans Serif,11'
$objTextBox1.Hide()
$objTextBox1.Text=$Global:init["opschonen"]["dagenbewarenbackup"]
$objTextBox1.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})


$objTextBox2 = New-Object System.Windows.Forms.TextBox 
$objTextBox2.Location = New-Object System.Drawing.Size(380,190) 
$objTextBox2.Size = New-Object System.Drawing.Size(55,50)
$objTextBox2.MaxLength = 4
$objTextBox2.Font = 'Microsoft Sans Serif,11'
$objTextBox2.Hide()
$objTextBox2.Text=$Global:init["opschonen"]["dagenbewarenlogs"]
$objTextBox2.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})

$Btnaccept = New-object System.Windows.Forms.Button 
$Btnaccept.text= "Bevestigen"
$Btnaccept.location = "50,310" 
$Btnaccept.size = "150,30"  
$Btnaccept.BackColor = 'green'
$Btnaccept.ForeColor = 'white'
$Btnaccept.add_click({ 
    uitvoerenopschonen
    })
$Btnaccept.Enabled=$false
$Btnaccept.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,310" 
$Btnescape.size = "150,30"
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})

$LogButton = New-Object System.Windows.Forms.Button
$LogButton.Location = New-Object System.Drawing.Size(50, 310)
$LogButton.Size = New-Object System.Drawing.Size(150, 30)
$LogButton.Text = "Logbestand bekijken"
#$LogButton.height = 40
$LogButton.BackColor = 'blue'
$LogButton.ForeColor = 'white'
$LogButton.hide()
$LogButton.add_click({ 
    $Form2.close()
    vensterlogbestand })


# het proces zichtbaar maken in een balk
$ProgressBar = New-Object System.Windows.Forms.ProgressBar
$ProgressBar.Location = New-Object System.Drawing.Point(20, 240)
$ProgressBar.Size = New-Object System.Drawing.Size(600, 40)
$ProgressBar.Style = "continuous"
$ProgressBar.step = 1
$progressBar.Visible=$false

# venster met uitleg over deze taak wordt gedeclareerd.
declareren_uitlegvenster "Uitleg over het venster Verwijder oude backups en oude logbestanden." 680 200 450 310 "Hier kunnen oude backups van de studentmappen en/of oude logbestanden verwijderd worden.

Maak een keuze door het betreffende vakje aan te vinken.
Wijzigen eventueel tot hoeveel dagen oud de bestanden bewaard blijven.

Om naar het overzicht te gaan waar u het verwijderen kan starten moet u op Bevestigen klikken." 


$Form2.Controls.AddRange(@($uitvoerenbackups, $uitvoerenlogbestanden, $description1, $description2, $Description3, $Description4, $objTextBox1, $objTextBox2, $uitleg_opschonen, $Btnaccept, $Btnescape, $LogButton, $ProgressBar, $Global:vraagtekenicoon ))

# openen venster
$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()

} # einde vensteropschonen

function info_venster_vullen ($keuze) {

# infovenster en tijdelijke object legen. wordt gebruikt bij function informatieprogramma
$objtekst1.Text = "Het bestand wordt geladen ..."
$objtekst_temp.text = ""

# inhoud bestand inlezen
if ($keuze -eq "readme") { 
    $volledigetext = Get-Content -Path "$tempreadmebestand"
    } else {
    $volledigetext = Get-Content -Path "$tempchangelogbestand"
    }

# dan netjes in rijen plaatsen.
foreach ($item in $volledigetext) {
               $objtekst_temp.Text = $objtekst_temp.Text + "$item" + "`r`n"
               }

$objtekst1.Text = $objtekst_temp.text 
} # einde info_venster_vullen

function informatieprogramma {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# aangeven wat de inhoud is van de infovenster, readme of changelog
$global:infovenster = "changelog"

# venster declareren
$Form2 = declareren_standaardvenster "Informatie over het programma" 960 690

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Naam van het programma :
Versie : 
Build :
Progammeur :
Afbeeldingen :"

$Description2.AutoSize            = $false
$Description2.width               = 300
$Description2.height              = 100
$Description2.location            = New-Object System.Drawing.Point(20,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Beherenbestanden
$global:versie
$extralabel
Benvindo Neves
Marco Laluan"

$Description3.AutoSize            = $false
$Description3.width               = 200
$Description3.height              = 100
$Description3.location            = New-Object System.Drawing.Point(330,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue


$Btninfovenster = New-object System.Windows.Forms.Button 
#$Btninfovenster.text= "Changelog bekijken"
$Btninfovenster.location = "230,600" 
$Btninfovenster.size = "180,30"  
$Btninfovenster.BackColor = 'blue'
$Btninfovenster.ForeColor = 'white'
if ($global:infovenster -eq "readme") { 
        $Btninfovenster.text= "Changelog bekijken"
        } else { 
        $Btninfovenster.text= "Readme bekijken"
        } 
$Btninfovenster.add_click({ 
    if ($global:infovenster -eq "readme") { 
        $global:infovenster="changelog" 
        $Btninfovenster.text= "Readme bekijken"
        } else { 
        $global:infovenster="readme" 
        $Btninfovenster.text= "Changelog bekijken"
        } 
    # infovenster vullen met infobestand
    info_venster_vullen $global:infovenster
})
$Btninfovenster.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Verander de inhoud van het informatievakje tussen Readme en Changelog." )
})


$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,600" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'red'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Buttenok.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster." )
})

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,115) 
$objtekst1.Size = New-Object System.Drawing.Size(920,475)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'

# dit object maakt dat het laden van het bestand en laten zien in het venster sneller gaat
# zie ook function info_venster_vullen
$objtekst_temp = New-Object System.Windows.Forms.textbox


# tijdelijke bestanden benoemen
$tempreadmebestand="$startmap\temp_$readmebestand"
$tempchangelogbestand="$startmap\temp_$changelogbestand"

# downloaden readmebestand en foutmeldingen opvangen
$error.clear()
$downloadbestand = -join ("$updatewebsite","/","$readmebestand")
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$tempreadmebestand" -ErrorAction Stop
    }
catch {
    vraagvenster "Geen readme gevonden" "Het is niet gelukt om het readme-bestand te downloaden." "Sluiten" 
    "Het readme-bestand is niet gedownload en kan dus niet getoont worden." | Out-File "$tempreadmebestand"
}
# downloaden changelogbestand en foutmeldingen opvangen
$error.clear()
$downloadbestand = -join ("$updatewebsite","/","$changelogbestand")
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$tempchangelogbestand" -ErrorAction Stop
    }
catch {
    vraagvenster "Geen changelog gevonden" "Het is niet gelukt om het changelog-bestand te downloaden." "Sluiten" 
    "Het changelog-bestand is niet gedownload en kan dus niet getoont worden." | Out-File "$tempchangelogbestand"
}

# infovenster vullen met infobestand
info_venster_vullen $global:infovenster

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over het venster Informatie over het programma." 680 250 500 600 "Bovenaan ziet u enkele gegevens over dit programma.

In het grote vakje kunt u eventueel de readme- of de changelog-bestand bekijken.
De README-bestand is een bestand die eerst gelezen moet worden, voorafgaand aan compilatie, installatie of eerste gebruik.
De CHANGELOG-bestand is een bestand met de wijzigingen per versie.

Door op de blauwe knop onderaan te klikken wijzigt u de inhoud." 

$Form2.Controls.AddRange(@($Description2, $Description3, $Buttenok, $Btninfovenster, $objtekst1, $Global:vraagtekenicoon))

# venster starten
$null = $form2.ShowDialog()

# temp bestanden verwijderen
Remove-Item "$tempreadmebestand" -force
Remove-Item "$tempchangelogbestand" -force

# De hoofdmenu zichtbaar maken
$form.show()
} # einde informatieprogramma

function opschonenlogsbijstart {

# alleen starten als dit is ingesteld
if ($global:init["opschonen"]["opschonenlogs"] -eq "Nee") {
    return;
}

# mappen controleren of deze bestaan
if (!(test-path -path "$logmap")) {
return;
}

# aantal dagen dat bestanden bewaard blijven uit object halen
[int32]$getal2 = $global:init["opschonen"]["dagenbewarenlogs"]

# aantal logbestanden die worden verwijderd tellen
$tellerlogs=0
Get-ChildItem -Path "$logmap" | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        $tellerlogs++
}
# Stoppen als er niets is om te verwijderen
if ( $tellerlogs -eq 0) {
    return;
}

# start proces verwijderen

# weergeven in venster
$opstartinfo.text = "Opschonen logbestanden ..."
$Form_opstart.Refresh()

# datum bepalen
$datumvandaag = bepaaldatum;

# logbestandsnaam definiren en volledige pad naar bestand invoeren
$logbestand = bepaallognaam "$datumvandaag"

# starttijd van loggen naar variabele
$logtijd = get-date -Format "HH:mm:ss"

#foutmelding voor logbestand
$foutmelding_log="[ FOUT ] "

# in logbestand schrijven
"Het opschonen van logbestanden is uitgevoerd." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append

# in logbestand info schrijven
"De volgende $tellerlogs logbestanden ouder dan $getal2 dagen verwijderen : " | out-file $logbestand -Append

# bepaal de lijst met mappen die verwijderd worden
 Get-ChildItem -Path "$logmap" | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        # map om te verwijderen
        $todelete = $_
        # in logbestand schrijven
        " - $todelete " | out-file $logbestand -Append

        #verwijderen map en opvangen foutmelding met try- catch methode
        $error.clear()

        try {
            Remove-Item "$logmap\$todelete" -force -ErrorAction Stop 
            }

        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_ | out-file $logbestand -Append
              } # einde try catch
} # einde get-childitem

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
# alleen uitvoeren als aantal dagen verwijderen logs > 0. Zo wordt alles verwijderd als je dit als 0 insteld.
if ( $getal2 -gt 0) {
    $logtijd = get-date -Format "HH:mm:ss"

    "" | out-file $logbestand -Append
    "Eindtijd  : $logtijd" | out-file $logbestand -Append
    " -------------------------------------------------------------------------" | out-file $logbestand -Append
    "" | out-file $logbestand -Append
} # einde if 

} # einde opschonenlogsbijstart


# initialiseren van programma ---------------------------------------------------------------


# opstart venster declareren en weergeven ----------------------------------------------------------------------
$Form_opstart                     = New-Object system.Windows.Forms.Form
$Form_opstart.ClientSize          = New-Object System.Drawing.Point(450,180)
$Form_opstart.text                = "Beheren bestanden versie " + "$global:Versie"
$Form_opstart.TopMost             = $false
$Form_opstart.StartPosition       = 'CenterScreen'
$Form_opstart.BackColor           = "white"
$Form_opstart.ControlBox = $False

$opstarttekst                     = New-Object system.Windows.Forms.Label
$opstarttekst.text                = "Programma wordt opgestart."
$opstarttekst.AutoSize            = $false
$opstarttekst.width               = 300
$opstarttekst.height              = 30
$opstarttekst.location            = New-Object System.Drawing.Point(20,15)
$opstarttekst.Font                = 'Microsoft Sans Serif,12'
$opstarttekst.ForeColor = [System.Drawing.Color]::Blue
$Form_opstart.Controls.Add($opstarttekst)

$opstartinfo                     = New-Object system.Windows.Forms.Label
$opstartinfo.text                = "Initialiseren ..."
$opstartinfo.AutoSize            = $false
$opstartinfo.width               = 400
$opstartinfo.height              = 100
$opstartinfo.location            = New-Object System.Drawing.Point(20,50)
$opstartinfo.Font                = 'Microsoft Sans Serif,12'
$opstartinfo.ForeColor = [System.Drawing.Color]::Blue
$Form_opstart.Controls.Add($opstartinfo)

$Form_opstart.Show()

# nodig om proces de tijd te geven om de teksten te laten zien.
Start-Sleep -Milliseconds 500



# Hoofdvenster declareren --------------------------------------------------------------------

$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = New-Object System.Drawing.Point(900,550)
$Form.text                       = "Beheren bestanden versie " + "$global:Versie"
$Form.TopMost                    = $false
$Form.StartPosition              = 'CenterScreen'
$form.BackColor = "white"
$form.MaximizeBox = $False

$Description                     = New-Object system.Windows.Forms.Label
$Description.text                = "MAAK EEN KEUZE DOOR OP EEN ICOONTJE TE KLIKKEN."
$Description.AutoSize            = $false
$Description.width               = 500
$Description.height              = 35
$Description.location            = New-Object System.Drawing.Point(52,15)
$Description.Font                = 'Microsoft Sans Serif,12'
# $Description.ForeColor = [System.Drawing.Color]::Blue
$Form.controls.add($Description)

$uitleg1                     = New-Object system.Windows.Forms.Label
$uitleg1.text                = "Bestanden klaarzetten"
$uitleg1.AutoSize            = $false
$uitleg1.width               = 160
$uitleg1.height              = 20
$uitleg1.location            = New-Object System.Drawing.Point(56, 215)
$uitleg1.Font                = 'Microsoft Sans Serif,11'
$uitleg1.ForeColor = [System.Drawing.Color]::Blue
$Form.controls.add($uitleg1)
$uitleg1.Add_Click({ vensterkopieren })

$uitleg2                     = New-Object system.Windows.Forms.Label
$uitleg2.text                = "Backup maken"
$uitleg2.AutoSize            = $false
$uitleg2.width               = 160
$uitleg2.height              = 20
$uitleg2.location            = New-Object System.Drawing.Point(290, 215)
$uitleg2.Font                = 'Microsoft Sans Serif,11'
$uitleg2.ForeColor = [System.Drawing.Color]::blue
$Form.controls.add($uitleg2)
$uitleg2.Add_Click({ vensterbackup })

$uitleg3                     = New-Object system.Windows.Forms.Label
$uitleg3.text                = "Wissen"
$uitleg3.AutoSize            = $false
$uitleg3.width               = 80
$uitleg3.height              = 20
$uitleg3.location            = New-Object System.Drawing.Point(530,215)
$uitleg3.Font                = 'Microsoft Sans Serif,11'
$uitleg3.ForeColor = [System.Drawing.Color]::blue
$Form.controls.add($uitleg3)
# $uitleg3.Add_Click({ vensterwissen })

$uitleg4                     = New-Object system.Windows.Forms.Label
$uitleg4.text                = "Verplaatsen of kopiren"
$uitleg4.AutoSize            = $false
$uitleg4.width               = 170
$uitleg4.height              = 20
$uitleg4.location            = New-Object System.Drawing.Point(688,215)
$uitleg4.Font                = 'Microsoft Sans Serif,11'
$uitleg4.ForeColor = [System.Drawing.Color]::blue
$Form.controls.add($uitleg4)
# $uitleg4.Add_Click({ vensterverplaatsen })



$Button1                         = New-Object system.Windows.Forms.Button
$Button1.width                   = 160
$Button1.height                  = 160
$Button1.location                = New-Object System.Drawing.Point(52,50)
$Button1.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button1.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon bestanden klaarzetten.png")
$Button1.BackColor = [System.Drawing.Color]::green
$Button1.Add_Click({ vensterkopieren })
$Button1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bestanden klaarzetten voor de geselecteerde pc's in een netwerk." )
})
$Form.controls.add($Button1)

$Button2                         = New-Object system.Windows.Forms.Button
$Button2.width                   = 160
$Button2.height                  = 160
$Button2.location                = New-Object System.Drawing.Point(264,50)
$Button2.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button2.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon backup maken.png")
$Button2.BackColor = [System.Drawing.Color]::green
$Button2.Add_Click({ vensterbackup })
$Button2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Backup maken van de bestanden in de geselecteerde pc's." )
})
$Form.controls.add($Button2)

$Button3                         = New-Object system.Windows.Forms.Button
$Button3.width                   = 160
$Button3.height                  = 160
$Button3.location                = New-Object System.Drawing.Point(476,50)
$Button3.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button3.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon wissen.png")
$Button3.BackColor = [System.Drawing.Color]::green
$Button3.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bestanden verwijderen uit de geselecteerde pcs in het netwerk." )
})
$Button3.Add_Click({ vensterwissen })

$Form.controls.add($Button3)

$Button4                         = New-Object system.Windows.Forms.Button
$Button4.width                   = 160
$Button4.height                  = 160
$Button4.location                = New-Object System.Drawing.Point(688,50)
$Button4.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button4.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon verplaatsen.png")
$Button4.BackColor = [System.Drawing.Color]::green
$Button4.Add_Click({ vensterverplaatsen })
$Button4.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bestanden van n pc verplaatsen of kopieren naar een andere pc." )
})
$Form.controls.add($Button4)

$Button5                         = New-Object system.Windows.Forms.Button
$Button5.width                   = 60
$Button5.height                  = 60
$Button5.location                = New-Object System.Drawing.Point(52,270)
$Button5.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button5.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-log.png")
# $Button7.BackColor = [System.Drawing.Color]::blue
$Button5.Add_Click({ vensterlogbestand })
$Button5.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "De logbestanden van de uitgevoerde taken bekijken." )
})
$Form.controls.add($Button5)

$Button6                         = New-Object system.Windows.Forms.Button
$Button6.width                   = 60
$Button6.height                  = 60
$Button6.location                = New-Object System.Drawing.Point(52,360)
$Button6.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-info.png")
$Button6.Add_Click({ informatieprogramma })
$Button6.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Algemene informatie over het programma lezen." )
})
$Form.controls.add($Button6)

$Button7                         = New-Object system.Windows.Forms.Button
$Button7.width                   = 60
$Button7.height                  = 60
$Button7.location                = New-Object System.Drawing.Point(52,450)
$Button7.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button7.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-stoppen.png")
$Button7.BackColor = [System.Drawing.Color]::red
$Button7.Add_Click({ programmaafsluiten })
$Button7.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Het programma afsluiten." )
})
$Form.controls.add($Button7)

$Button8                         = New-Object system.Windows.Forms.Button
$Button8.width                   = 60
$Button8.height                  = 60
$Button8.location                = New-Object System.Drawing.Point(788,270)
$Button8.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button8.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-update.png")
# $Button8.BackColor = [System.Drawing.Color]::blue
$Button8.Add_Click({ updatevoorbereiden ("keuzemenu") })
$Button8.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Handmatig het programma updaten." )
})
$Form.controls.add($Button8)

$Button9                         = New-Object system.Windows.Forms.Button
$Button9.width                   = 60
$Button9.height                  = 60
$Button9.location                = New-Object System.Drawing.Point(788,360)
$Button9.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button9.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-settings.png")
# $Button9.BackColor = [System.Drawing.Color]::blue
$Button9.Add_Click({ vensterinstellingen })
$Button9.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "De standaard keuzes voor de taken en overige functies van het programma wijzigen." )
})
$Form.controls.add($Button9)

$Button10                         = New-Object system.Windows.Forms.Button
$Button10.width                   = 60
$Button10.height                  = 60
$Button10.location                = New-Object System.Drawing.Point(788,450)
$Button10.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-clean.png")
# $Button10.BackColor = [System.Drawing.Color]::blue
$Button10.Add_Click({ vensteropschonen })
$Button10.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Oude backups en oude logbestanden verwijderen." )
})
$Form.controls.add($Button10)

# declareren venster met uitleg over programma. verschijnt als de muis over de vraagteken gaat.

$Form_uitlegprog = declareren_standaardvenster "Uitleg over het programma" 690 480
$Form_uitlegprog.ControlBox = $False
# $Form_uitlegprog.maximizebox = $False
# $Form_uitlegprog.minimizebox = $False

$uitlegprogtekst                     = New-Object system.Windows.Forms.Label
$uitlegprogtekst.text                = "Met dit programma kunnen bestanden op meerdere pc's in een netwerk worden beheerd.
De vier belangrijkste taken van dit programma worden met een groene icoontje weergegeven.

Met het icoontje 
    - 'Bestanden klaarzetten' worden bestanden en volledige mappen overgezet naar 
       de geselecteerde pc's.
    - 'Backup maken' wordt een backup gemaakt van de bestanden in de geselecteerde pc's.
    - 'Wissen' worden de bestanden van de geselecteerde pc's gewist.
    - 'Verplaatsen of kopiren' worden de bestanden van n pc verplaatst of gekopierd naar 
       een andere pc.

Met de drie icoontjes aan de linkerkant kunnen:
    - de logbestanden van de uitgevoerde taken bekeken worden,
    - algemene informatie over het programma worden gelezen,
    - het programma worden afgesloten.

Met de drie icoontjes aan de rechterkant kan / kunnen:
    - het programma handmatig worden gepdatet,  
    - de standaard keuzes voor de taken en overige functies van het programma worden gewijzigd,
    - oude backups en oude logbestanden worden verwijderd. 

Informatie over een taak kan verkregen worden door met de muiscursor over een object te gaan.
"
$uitlegprogtekst.AutoSize            = $false
$uitlegprogtekst.width               = 680
$uitlegprogtekst.height              = 380
$uitlegprogtekst.location            = New-Object System.Drawing.Point(10,10)
$uitlegprogtekst.Font                = 'Microsoft Sans Serif,11'
$uitlegprogtekst.ForeColor = [System.Drawing.Color]::blue
$Form_uitlegprog.Controls.Add($uitlegprogtekst)

$knopsluiten = New-object System.Windows.Forms.Button 
$knopsluiten.text= 'Sluiten'
$knopsluiten.location = "250,400" 
$knopsluiten.size = "150,30"  
$knopsluiten.BackColor = 'red'
$knopsluiten.ForeColor = 'white'
$knopsluiten.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Form_uitlegprog.Controls.Add($knopsluiten)

# einde declareren venster met uitleg over programma

# declareren vraag-icoontje om extra informatiete geven over het programma
$picturequestion = new-object Windows.Forms.PictureBox
$picturequestion.Location = New-Object System.Drawing.Size(720,500)
$picturequestion.Size = New-Object System.Drawing.Size(30,60)
$picturequestion.Image = [System.Drawing.Image]::FromFile("$icoontjesmap\icoon-hulp.png")
$picturequestion.add_click( { $Form_uitlegprog.showdialog() } )
$picturequestion.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Klik hier voor uitleg over het programma." )
})
$Form.controls.add($picturequestion)

#GIF afbeelding toevoegen
$gifBox = New-Object Windows.Forms.picturebox
# $gifLink= (Get-Item -Path '.\filetransfer.gif')
# $img = [System.Drawing.Image]::fromfile($gifLink)
$gifBox.AutoSize = $true
$gifBox.Image = [System.Drawing.Image]::FromFile("$icoontjesmap\filetransfer.gif")
# $gifBox.location                = New-Object System.Drawing.Point(140,250)
$gifBox.location                = New-Object System.Drawing.Point(130,226)
$Form.Controls.Add($gifbox)

# Einde hoofdvenster declareren


# oude initialisatiebestand inlezen en omzetten
# dit kan verwijderd worden als iedereen minimaal versie 4.2.2 heeft.
$init_oud = "gebruiker.ini"

if (test-path -path $init_oud -pathtype leaf) { 
# inlezen oude ini-bestand naar object
$myobject = Get-IniContent $init_oud

# bewaren als hashwaarden in nieuwe initbestand
$myobject | ConvertTo-Json -depth 1 | Set-Content -Path $global:initbestand

# verwijderen oude init
Remove-Item -Path $init_oud
}

# standaard instellingen bepalen voor object $init
$global:init = standaardinstellingen

# inlezen initialisatiebestand als deze bestaat en toevoegen of verwijderen waarden van $init
# dit is nodig zodat, als de initialisatiebestand wordt ingelezen, eventuele nieuwe variabelen worden behouden en verwijderde variabelen niet worden toegevoegd. 
if (test-path -path $global:initbestand -pathtype leaf) { 
    # inlezen van object als hashwaarden. hier staan de gewijzigde waarden in die je wil behouden.
    $myObject = Get-Content -Path $global:initbestand | ConvertFrom-Json

    # waarden overzetten naar $init. nieuwe waarden worden behouden. verwijderde waarden worden niet toegevoegd.
    foreach( $property in $myobject.psobject.properties.name ) {
        foreach( $subproperty in $myobject.$property.psobject.properties.name )
        {
        # alleen toevoegen als deze bij 'init' al bestaat
        if ( $global:init.$property.$subproperty -ne $null) { 
            $global:init[$property][$subproperty] = $myObject.$property.$subproperty 
            }
        } # einde foreach $subproperty - loop 
        } # einde foreach $property - loop    

    # gekozen is om dit altijd te bewaren zodat je lijst met variabelen up to date is.
    $global:init | ConvertTo-Json -depth 1 | Set-Content -Path $global:initbestand    
    } 

<# verwijderen oude initialisatiebestand als deze bestaat
   dit kan op een gegeven moment als iedereen up to date is, verwijderd worden.
   vanaf versie 4.2.1 wordt config.ini niet meer gebruikt.
   eerst oude initbestand bepalen
#>
$oudeinit = -join ("$startmap","\","config.ini")
if (test-path -path $oudeinit -pathtype leaf) { 
    Remove-Item -Path $oudeinit -force
}

# einde intialiseren programma

# controleren op een update. alleen als hiervoor al geen update is uitgevoerd.
updatevoorbereiden ("begin");

# opschonen logbestanden als dit is ingesteld
opschonenlogsbijstart;

# opstart venster sluiten voor het tonen van hoofdvenster
Start-Sleep -Milliseconds 500
$Form_opstart.dispose()

# Form wordt getoond. dit is de hoofdvenster
$null = $Form.ShowDialog()
